/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.oauth2;

import android.app.Activity;
import android.content.IntentFilter;
import android.util.Log;
import java.net.URI;
import org.jboss.aerogear.android.authorization.AuthzModule;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.jboss.aerogear.android.pipe.module.AuthorizationFields;
import org.jboss.aerogear.android.pipe.module.ModuleFields;

public abstract class OAuth2AuthzModule
implements AuthzModule {
    private static final IntentFilter AUTHZ_FILTER = new IntentFilter();
    protected final String accountId;
    protected final String clientId;
    protected final OAuth2Properties config;
    protected OAuth2AuthzSession account;
    protected OAuth2AuthzService service;
    public final String TAG = OAuth2AuthzModule.class.getSimpleName();

    public OAuth2AuthzModule(OAuth2Properties config) {
        this.clientId = config.getClientId();
        this.accountId = config.getAccountId();
        this.config = config;
    }

    @Override
    public final boolean isAuthorized() {
        if (this.account == null) {
            return false;
        }
        return this.account.tokenIsNotExpired() && !this.isNullOrEmpty(this.account.getAccessToken());
    }

    @Override
    public final boolean hasCredentials() {
        if (this.account == null) {
            return false;
        }
        return !this.isNullOrEmpty(this.account.getAccessToken());
    }

    @Override
    public abstract void requestAccess(Activity var1, Callback<String> var2);

    @Override
    public final AuthorizationFields getAuthorizationFields(URI requestUri, String method, byte[] requestBody) {
        AuthorizationFields fields = new AuthorizationFields();
        fields.addHeader("Authorization", "Bearer " + this.account.getAccessToken());
        return fields;
    }

    @Override
    public final boolean refreshAccess() {
        if (!this.hasAccount()) {
            return false;
        }
        if (this.isAuthorized()) {
            return true;
        }
        try {
            this.service.fetchAccessToken(this.accountId, this.config);
            this.account = this.service.getAccount(this.accountId);
            Log.d((String)this.TAG, (String)"Access token refresh complete!");
            return true;
        }
        catch (OAuth2AuthorizationException ex) {
            Log.e((String)this.TAG, (String)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    protected boolean hasAccount() {
        return !this.isNullOrEmpty(this.accountId) && this.service.hasAccount(this.accountId);
    }

    public final ModuleFields loadModule(URI relativeURI, String httpMethod, byte[] requestBody) {
        AuthorizationFields authzFields = this.getAuthorizationFields(relativeURI, httpMethod, requestBody);
        ModuleFields moduleFields = new ModuleFields();
        moduleFields.setHeaders(authzFields.getHeaders());
        moduleFields.setQueryParameters(authzFields.getQueryParameters());
        return moduleFields;
    }

    public final boolean handleError(HttpException exception) {
        int statusCode = exception.getStatusCode();
        if (statusCode == 401 || statusCode == 403) {
            return this.refreshAccess() && this.isAuthorized();
        }
        return false;
    }

    @Override
    public final void deleteAccount() {
        this.service.removeAccount(this.accountId);
        this.removeAccount();
    }

    protected boolean isNullOrEmpty(String testString) {
        return testString == null || testString.isEmpty();
    }

    protected void setAccount(OAuth2AuthzSession account) {
        this.account = account;
    }

    protected void removeAccount() {
        this.account = null;
    }

    static {
        AUTHZ_FILTER.addAction("org.jboss.aerogear.android.authz.RECEIVE_AUTHZ");
    }
}

