/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.oauth2;

import android.app.Activity;
import android.net.Uri;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthorizationException;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Utils;
import org.jboss.aerogear.android.authorization.oauth2.OAuthWebViewDialog;
import org.jboss.aerogear.android.core.Callback;

public class OAuth2WebFragmentFetchAutorization {
    private final Activity activity;
    private final String state;

    public OAuth2WebFragmentFetchAutorization(Activity activity, String state) {
        this.activity = activity;
        this.state = state;
    }

    public void performAuthorization(OAuth2Properties config, Callback<String> callback) {
        try {
            this.doAuthorization(config, callback);
        }
        catch (UnsupportedEncodingException ex) {
            callback.onFailure((Exception)ex);
        }
        catch (MalformedURLException ex) {
            callback.onFailure((Exception)ex);
        }
    }

    private void doAuthorization(OAuth2Properties config, final Callback<String> callback) throws UnsupportedEncodingException, MalformedURLException {
        URL baseURL = config.getBaseURL();
        Uri redirectURL = Uri.parse((String)config.getRedirectURL());
        URL authzURL = OAuth2Utils.buildAuthzURL(config, this.state);
        final OAuthWebViewDialog dialog = OAuthWebViewDialog.newInstance(authzURL, redirectURL);
        dialog.setReceiver(new OAuthWebViewDialog.OAuthReceiver(){

            @Override
            public void receiveOAuthCode(String code) {
                dialog.removeReceive();
                dialog.dismiss();
                callback.onSuccess((Object)code);
            }

            @Override
            public void receiveOAuthError(String error) {
                dialog.removeReceive();
                dialog.dismiss();
                callback.onFailure((Exception)new OAuth2AuthorizationException(error));
            }
        });
        dialog.setStyle(16973837, 0);
        dialog.show(this.activity.getFragmentManager(), "TAG");
    }
}

