/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authorization.oauth2.webview;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import java.util.UUID;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzModule;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzService;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2AuthzSession;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2FetchAccess;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2Properties;
import org.jboss.aerogear.android.authorization.oauth2.OAuth2WebFragmentFetchAutorization;
import org.jboss.aerogear.android.core.Callback;

public class OAuth2WebViewAuthzModule
extends OAuth2AuthzModule {
    private static final IntentFilter AUTHZ_FILTER = new IntentFilter();
    private final String TAG = OAuth2WebViewAuthzModule.class.getSimpleName();

    public OAuth2WebViewAuthzModule(OAuth2Properties config) {
        super(config);
    }

    @Override
    public void requestAccess(final Activity activity, final Callback<String> callback) {
        final String state = UUID.randomUUID().toString();
        OAuth2AuthzService.AGAuthzServiceConnection connection = new OAuth2AuthzService.AGAuthzServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName className, IBinder iBinder) {
                super.onServiceConnected(className, iBinder);
                OAuth2WebViewAuthzModule.this.doRequestAccess(state, activity, (Callback<String>)callback, this);
            }
        };
        activity.bindService(new Intent(activity.getApplicationContext(), OAuth2AuthzService.class), (ServiceConnection)connection, 1);
    }

    private void doRequestAccess(String state, Activity activity, Callback<String> callback, OAuth2AuthzService.AGAuthzServiceConnection instance) {
        this.service = instance.getService();
        if (this.isNullOrEmpty(this.accountId)) {
            throw new IllegalArgumentException("need to have accountId set");
        }
        if (!this.service.hasAccount(this.accountId)) {
            OAuth2WebFragmentFetchAutorization authzFetch = new OAuth2WebFragmentFetchAutorization(activity, state);
            authzFetch.performAuthorization(this.config, new OAuth2AuthorizationCallback(activity, callback, instance));
        } else {
            OAuth2FetchAccess fetcher = new OAuth2FetchAccess(this.service);
            fetcher.fetchAccessCode(this.accountId, this.config, new OAuth2AccessCallback(activity, callback, instance));
        }
    }

    static {
        AUTHZ_FILTER.addAction("org.jboss.aerogear.android.authz.RECEIVE_AUTHZ");
    }

    private class OAuth2AuthorizationCallback
    implements Callback<String> {
        private final Activity callingActivity;
        private final Callback<String> originalCallback;
        private final ServiceConnection serviceConnection;
        private final Handler myHandler;

        public OAuth2AuthorizationCallback(Activity callingActivity, Callback<String> originalCallback, ServiceConnection serviceConnection) {
            this.callingActivity = callingActivity;
            this.originalCallback = originalCallback;
            this.serviceConnection = serviceConnection;
            this.myHandler = new Handler(Looper.myLooper());
        }

        public void onSuccess(String code) {
            OAuth2AuthzSession session = new OAuth2AuthzSession();
            session.setAuthorizationCode(code);
            session.setAccountId(OAuth2WebViewAuthzModule.this.accountId);
            session.setClientId(OAuth2WebViewAuthzModule.this.clientId);
            OAuth2WebViewAuthzModule.this.service.addAccount(session);
            OAuth2FetchAccess fetcher = new OAuth2FetchAccess(OAuth2WebViewAuthzModule.this.service);
            fetcher.fetchAccessCode(OAuth2WebViewAuthzModule.this.accountId, OAuth2WebViewAuthzModule.this.config, new OAuth2AccessCallback(this.callingActivity, this.originalCallback, this.serviceConnection));
        }

        public void onFailure(final Exception e) {
            this.myHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        OAuth2AuthorizationCallback.this.callingActivity.unbindService(OAuth2AuthorizationCallback.this.serviceConnection);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    OAuth2AuthorizationCallback.this.originalCallback.onFailure(e);
                }
            });
        }
    }

    private class OAuth2AccessCallback
    implements Callback<String> {
        private final Activity callingActivity;
        private final Callback<String> originalCallback;
        private final ServiceConnection serviceConnection;
        private final Handler myHandler;

        public OAuth2AccessCallback(Activity callingActivity, Callback<String> originalCallback, ServiceConnection serviceConnection) {
            this.callingActivity = callingActivity;
            this.originalCallback = originalCallback;
            this.serviceConnection = serviceConnection;
            this.myHandler = new Handler(Looper.myLooper());
        }

        public void onSuccess(final String accessToken) {
            OAuth2WebViewAuthzModule.this.account = OAuth2WebViewAuthzModule.this.service.getAccount(OAuth2WebViewAuthzModule.this.accountId);
            try {
                this.callingActivity.unbindService(this.serviceConnection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.myHandler.post(new Runnable(){

                @Override
                public void run() {
                    OAuth2AccessCallback.this.originalCallback.onSuccess((Object)accessToken);
                }
            });
        }

        public void onFailure(final Exception e) {
            this.myHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        OAuth2AccessCallback.this.callingActivity.unbindService(OAuth2AccessCallback.this.serviceConnection);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    OAuth2AccessCallback.this.originalCallback.onFailure(e);
                }
            });
        }
    }
}

