/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import junit.framework.Assert;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.impl.pipeline.LoaderAdapter;
import org.jboss.aerogear.android.impl.pipeline.SupportLoaderAdapter;
import org.jboss.aerogear.android.impl.pipeline.loader.AbstractPipeLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.ReadLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.support.AbstractSupportPipeLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.support.SupportReadLoader;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.pipe.test.MainActivity;
import org.jboss.aerogear.android.pipeline.AbstractActivityCallback;
import org.jboss.aerogear.android.pipeline.AbstractFragmentCallback;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.support.AbstractFragmentActivityCallback;
import org.jboss.aerogear.android.pipeline.support.AbstractSupportFragmentCallback;
import org.mockito.Mockito;

public class CallbackTest
extends PatchedActivityInstrumentationTestCase<MainActivity> {
    public CallbackTest() {
        super(MainActivity.class);
    }

    public void testPassModernFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        LoaderAdapter adapter = new LoaderAdapter(fragment, (Context)this.getActivity(), (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)fragmentCallback.successCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testFailSupportFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        android.support.v4.app.Fragment fragment = (android.support.v4.app.Fragment)Mockito.mock(android.support.v4.app.Fragment.class);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(fragment, (Context)this.getActivity(), (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidSupportFragmentCallback fragmentCallback = new VoidSupportFragmentCallback();
        SupportReadLoader loader = (SupportReadLoader)Mockito.mock(SupportReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        String data = "Data";
        SupportLoaderAdapter.CallbackHandler handler = new SupportLoaderAdapter.CallbackHandler(adapter, (AbstractSupportPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)fragmentCallback.failCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testPassFragmentActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        FragmentActivity activity = (FragmentActivity)Mockito.mock(FragmentActivity.class);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(activity, (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidFragmentActivityCallback activityCallback = new VoidFragmentActivityCallback();
        SupportReadLoader loader = (SupportReadLoader)Mockito.mock(SupportReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        String data = "Data";
        SupportLoaderAdapter.CallbackHandler handler = new SupportLoaderAdapter.CallbackHandler(adapter, (AbstractSupportPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)activityCallback.successCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    public void testFailFragmentActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        FragmentActivity activity = (FragmentActivity)Mockito.mock(FragmentActivity.class);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(activity, (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidFragmentActivityCallback activityCallback = new VoidFragmentActivityCallback();
        SupportReadLoader loader = (SupportReadLoader)Mockito.mock(SupportReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        String data = "Data";
        SupportLoaderAdapter.CallbackHandler handler = new SupportLoaderAdapter.CallbackHandler(adapter, (AbstractSupportPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)activityCallback.failCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    public void testPassSupportFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        android.support.v4.app.Fragment fragment = (android.support.v4.app.Fragment)Mockito.mock(android.support.v4.app.Fragment.class);
        SupportLoaderAdapter adapter = new SupportLoaderAdapter(fragment, (Context)this.getActivity(), (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidSupportFragmentCallback fragmentCallback = new VoidSupportFragmentCallback();
        SupportReadLoader loader = (SupportReadLoader)Mockito.mock(SupportReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        String data = "Data";
        SupportLoaderAdapter.CallbackHandler handler = new SupportLoaderAdapter.CallbackHandler(adapter, (AbstractSupportPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)fragmentCallback.successCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testFailModernFragmentCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Fragment fragment = (Fragment)Mockito.mock(Fragment.class);
        LoaderAdapter adapter = new LoaderAdapter(fragment, (Context)this.getActivity(), (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidFragmentCallback fragmentCallback = new VoidFragmentCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)fragmentCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)fragmentCallback.failCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)fragmentCallback, "fragment"));
    }

    public void testPassModernActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Activity activity = (Activity)Mockito.mock(Activity.class);
        LoaderAdapter adapter = new LoaderAdapter(activity, (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidActivityCallback activityCallback = new VoidActivityCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)activityCallback.successCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    public void testFailModernActivityCallbacks() throws IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        Activity activity = (Activity)Mockito.mock(Activity.class);
        LoaderAdapter adapter = new LoaderAdapter(activity, (Pipe)Mockito.mock(Pipe.class), "ignore");
        VoidActivityCallback activityCallback = new VoidActivityCallback();
        ReadLoader loader = (ReadLoader)Mockito.mock(ReadLoader.class);
        Mockito.when((Object)loader.getCallback()).thenReturn((Object)activityCallback);
        Mockito.when((Object)loader.hasException()).thenReturn((Object)true);
        Mockito.when((Object)loader.getException()).thenReturn((Object)new RuntimeException("This is only a test exception."));
        String data = "Data";
        LoaderAdapter.CallbackHandler handler = new LoaderAdapter.CallbackHandler(adapter, (AbstractPipeLoader)loader, (Object)data);
        handler.run();
        CallbackTest.assertTrue((boolean)activityCallback.failCalled);
        CallbackTest.assertNull((Object)UnitTestUtils.getSuperPrivateField((Object)activityCallback, "activity"));
    }

    private static class VoidFragmentActivityCallback
    extends AbstractFragmentActivityCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidFragmentActivityCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getFragmentActivity());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getFragmentActivity());
            this.failCalled = true;
        }
    }

    private static class VoidSupportFragmentCallback
    extends AbstractSupportFragmentCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidSupportFragmentCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getFragment());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getFragment());
            this.failCalled = true;
        }
    }

    private static class VoidActivityCallback
    extends AbstractActivityCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidActivityCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getActivity());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getActivity());
            this.failCalled = true;
        }
    }

    private static class VoidFragmentCallback
    extends AbstractFragmentCallback<Object> {
        boolean successCalled = false;
        boolean failCalled = false;

        public VoidFragmentCallback() {
            super(new Object[]{"HashCode"});
        }

        public void onSuccess(Object data) {
            Assert.assertNotNull((Object)this.getFragment());
            this.successCalled = true;
        }

        public void onFailure(Exception e) {
            Assert.assertNotNull((Object)this.getFragment());
            this.failCalled = true;
        }
    }
}

