/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.graphics.Point;
import android.test.AndroidTestCase;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.RecordId;
import org.jboss.aerogear.android.code.ModuleFields;
import org.jboss.aerogear.android.code.PipeModule;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.core.HttpProviderFactory;
import org.jboss.aerogear.android.impl.helper.Data;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.impl.http.HttpStubProvider;
import org.jboss.aerogear.android.impl.pipeline.GsonRequestBuilder;
import org.jboss.aerogear.android.impl.pipeline.GsonResponseParser;
import org.jboss.aerogear.android.impl.pipeline.PipeTypes;
import org.jboss.aerogear.android.impl.pipeline.RestAdapter;
import org.jboss.aerogear.android.impl.pipeline.RestfulPipeConfiguration;
import org.jboss.aerogear.android.impl.pipeline.paging.WrappingPagedList;
import org.jboss.aerogear.android.pipeline.MarshallingConfig;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeManager;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.ResponseParser;
import org.jboss.aerogear.android.pipeline.paging.MetadataLocation;
import org.jboss.aerogear.android.pipeline.paging.PageConfig;
import org.jboss.aerogear.android.pipeline.paging.PagedList;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class RestAdapterTest
extends AndroidTestCase {
    private static final String TAG = RestAdapterTest.class.getSimpleName();
    private static final String SERIALIZED_POINTS = "{\"points\":[{\"x\":0,\"y\":0},{\"x\":1,\"y\":2},{\"x\":2,\"y\":4},{\"x\":3,\"y\":6},{\"x\":4,\"y\":8},{\"x\":5,\"y\":10},{\"x\":6,\"y\":12},{\"x\":7,\"y\":14},{\"x\":8,\"y\":16},{\"x\":9,\"y\":18}],\"id\":\"1\"}";
    private static final String POINTS_ARRAY = "[{\"x\":0,\"y\":0},{\"x\":1,\"y\":2},{\"x\":2,\"y\":4},{\"x\":3,\"y\":6},{\"x\":4,\"y\":8},{\"x\":5,\"y\":10},{\"x\":6,\"y\":12},{\"x\":7,\"y\":14},{\"x\":8,\"y\":16},{\"x\":9,\"y\":18}]";
    private URL url;
    private final Provider<HttpProvider> stubHttpProviderFactory = new Provider<HttpProvider>(){

        public HttpProvider get(Object ... in) {
            return new HttpStubProvider((URL)in[0]);
        }
    };

    public void setUp() throws MalformedURLException, Exception {
        super.setUp();
        this.url = new URL("http://server.com/context/");
    }

    public void testPipeTypeProperty() throws Exception {
        RestAdapter restPipe = new RestAdapter(Data.class, this.url);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", this.stubHttpProviderFactory);
        Assert.assertEquals((String)"verifying the (default) type", (Object)PipeTypes.REST, (Object)restPipe.getType());
    }

    public void testPipeURLProperty() throws Exception {
        RestAdapter restPipe = new RestAdapter(Data.class, this.url);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", this.stubHttpProviderFactory);
        RestAdapterTest.assertEquals((String)"verifying the given URL", (String)"http://server.com/context/", (String)restPipe.getUrl().toString());
    }

    public void testPipeFactoryPipeConfigEncoding() {
        try {
            RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"data", RestfulPipeConfiguration.class)).withUrl(this.url);
            config.getRequestBuilder().getMarshallingConfig().setEncoding(Charset.forName("UTF-16"));
            RestAdapterTest.assertEquals((Object)Charset.forName("UTF-16"), (Object)config.getRequestBuilder().getMarshallingConfig().getEncoding());
            config.getRequestBuilder().getMarshallingConfig().setEncoding((Charset)null);
        }
        catch (IllegalArgumentException ignore) {
            return;
        }
        RestAdapterTest.fail((String)"Expected IllegalArgumentException");
    }

    public void testPipeFactoryPipeConfigGson() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        GsonResponseParser responseParser = new GsonResponseParser(builder.create());
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url).responseParser((ResponseParser)responseParser);
        Pipe restPipe = config.forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        Field gsonField = restRunner.getClass().getDeclaredField("responseParser");
        gsonField.setAccessible(true);
        GsonResponseParser gson = (GsonResponseParser)gsonField.get(restRunner);
        RestAdapterTest.assertEquals((Object)responseParser, (Object)gson);
    }

    public void testEncoding() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        Charset utf_16 = Charset.forName("UTF-16");
        final HttpStubProvider provider = new HttpStubProvider(this.url, new HeaderAndBody(SERIALIZED_POINTS.getBytes(utf_16), new HashMap()));
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create()));
        MarshallingConfig marshallingConfig = config.getRequestBuilder().getMarshallingConfig();
        marshallingConfig.setEncoding(utf_16);
        marshallingConfig = config.getResponseParser().getMarshallingConfig();
        marshallingConfig.setEncoding(utf_16);
        RestAdapter restPipe = new RestAdapter(ListClassId.class, this.url, config);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        this.runRead((Pipe)restPipe);
    }

    public void testConfigSetEncoding() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        Charset utf_16 = Charset.forName("UTF-16");
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class);
        config.withUrl(this.url).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).getRequestBuilder().getMarshallingConfig().setEncoding(utf_16);
        RestAdapter restPipe = (RestAdapter)config.forClass(ListClassId.class);
        RestAdapterTest.assertEquals((Object)utf_16, (Object)restPipe.getRequestBuilder().getMarshallingConfig().getEncoding());
    }

    public void testSingleObjectRead() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.url, response);
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        config.requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create()));
        RestAdapter restPipe = new RestAdapter(ListClassId.class, this.url, config);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        List result = this.runRead((Pipe)restPipe);
        List<Point> returnedPoints = ((ListClassId)result.get((int)0)).points;
        RestAdapterTest.assertEquals((int)10, (int)returnedPoints.size());
    }

    public void testSingleObjectReadWithNestedResult() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody("{\"result\":{\"points\":{\"points\":[{\"x\":0,\"y\":0},{\"x\":1,\"y\":2},{\"x\":2,\"y\":4},{\"x\":3,\"y\":6},{\"x\":4,\"y\":8},{\"x\":5,\"y\":10},{\"x\":6,\"y\":12},{\"x\":7,\"y\":14},{\"x\":8,\"y\":16},{\"x\":9,\"y\":18}],\"id\":\"1\"}}}".getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.url, response);
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        config.requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create()));
        config.getResponseParser().getMarshallingConfig().setDataRoot("result.points");
        RestAdapter restPipe = new RestAdapter(ListClassId.class, this.url, config);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        List result = this.runRead((Pipe)restPipe);
        List<Point> returnedPoints = ((ListClassId)result.get((int)0)).points;
        RestAdapterTest.assertEquals((int)10, (int)returnedPoints.size());
    }

    public void testReadArray() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(POINTS_ARRAY.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.url, response);
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        config.requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create()));
        config.getRequestBuilder().getMarshallingConfig().setDataRoot("");
        RestAdapter restPipe = new RestAdapter(Point.class, this.url, config);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        List result = this.runRead((Pipe)restPipe);
        RestAdapterTest.assertEquals((int)10, (int)result.size());
    }

    public void testGsonBuilderProperty() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        final ByteArrayOutputStream request = new ByteArrayOutputStream();
        final HttpStubProvider provider = new HttpStubProvider(this.url){

            @Override
            public HeaderAndBody put(String id2, byte[] data) {
                try {
                    request.write(data);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return new HeaderAndBody(data, new HashMap());
            }

            @Override
            public HeaderAndBody post(byte[] data) {
                try {
                    request.write(data);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                return new HeaderAndBody(data, new HashMap());
            }
        };
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        config.responseParser((ResponseParser)new GsonResponseParser(builder.create()));
        RestAdapter restPipe = new RestAdapter(ListClassId.class, this.url, config);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        ListClassId listClass = new ListClassId(true);
        final ArrayList returnedPoints = new ArrayList(10);
        restPipe.save((Object)listClass, (Callback)new Callback<ListClassId>(){

            public void onSuccess(ListClassId data) {
                returnedPoints.addAll(data.points);
                latch.countDown();
            }

            public void onFailure(Exception e) {
                throw new RuntimeException(e);
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        int expectedId = new JSONObject(SERIALIZED_POINTS).getInt("id");
        JSONArray expectedPoints = new JSONObject(SERIALIZED_POINTS).getJSONArray("points");
        int requestId = new JSONObject(new String(request.toByteArray())).getInt("id");
        JSONArray requestPoints = new JSONObject(new String(request.toByteArray())).getJSONArray("points");
        RestAdapterTest.assertEquals((int)expectedId, (int)requestId);
        RestAdapterTest.assertEquals((String)expectedPoints.toString(), (String)requestPoints.toString());
        RestAdapterTest.assertEquals(listClass.points, returnedPoints);
    }

    public void runReadWithFilterUsingUri() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        HttpProviderFactory factory = (HttpProviderFactory)Mockito.mock(HttpProviderFactory.class);
        Mockito.when((Object)factory.get(new Object[]{Matchers.anyObject()})).thenReturn(Mockito.mock(HttpProvider.class));
        RestAdapter adapter = new RestAdapter(Data.class, this.url);
        Object restRunner = UnitTestUtils.getPrivateField(adapter, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", factory);
        ReadFilter filter = new ReadFilter();
        filter.setLinkUri(URI.create("?limit=10&where=%7B%22model%22:%22BMW%22%7D"));
        adapter.read(filter, (Callback)new Callback<List<Data>>(){

            public void onSuccess(List<Data> data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                latch.countDown();
            }
        });
        latch.await(500L, TimeUnit.MILLISECONDS);
        ((HttpProviderFactory)Mockito.verify((Object)factory)).get(new Object[]{Matchers.eq((Object)new URL(this.url.toString() + "?limit=10&where=%7B%22model%22:%22BMW%22%7D"))});
    }

    public void runReadWithFilter() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        HttpProviderFactory factory = (HttpProviderFactory)Mockito.mock(HttpProviderFactory.class);
        Mockito.when((Object)factory.get(new Object[]{Matchers.anyObject()})).thenReturn(Mockito.mock(HttpProvider.class));
        ModuleFields authFields = new ModuleFields();
        PipeModule urlModule = (PipeModule)Mockito.mock(PipeModule.class);
        Mockito.when((Object)urlModule.loadModule((URI)Matchers.anyObject(), (String)Matchers.anyObject(), (byte[])Matchers.anyObject())).thenReturn((Object)authFields);
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        config.module(urlModule);
        RestAdapter adapter = new RestAdapter(Data.class, this.url, config);
        Object restRunner = UnitTestUtils.getPrivateField(adapter, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", factory);
        ReadFilter filter = new ReadFilter();
        filter.setLimit(Integer.valueOf(10));
        filter.setWhere(new JSONObject("{\"model\":\"BMW\"}"));
        adapter.read(filter, (Callback)new Callback<List<Data>>(){

            public void onSuccess(List<Data> data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                latch.countDown();
                Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, TAG, e);
            }
        });
        latch.await(500L, TimeUnit.MILLISECONDS);
        ((HttpProviderFactory)Mockito.verify((Object)factory)).get(new Object[]{new URL(this.url.toString() + "?limit=10&model=BMW")});
    }

    public void testLinkPagingReturnsData() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InterruptedException {
        final HttpStubProvider provider = new HttpStubProvider(this.url, new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap()));
        PageConfig pageConfig = new PageConfig();
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        RestfulPipeConfiguration pipeConfig = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        pipeConfig.requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create()));
        pipeConfig.pageConfig(pageConfig);
        Pipe dataPipe = pipeConfig.forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(dataPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        ReadFilter onePageFilter = new ReadFilter();
        onePageFilter.setLimit(Integer.valueOf(1));
        this.runRead(dataPipe, onePageFilter);
        List result = this.runRead(dataPipe, onePageFilter);
        RestAdapterTest.assertNotNull(result);
        RestAdapterTest.assertFalse((boolean)(result instanceof PagedList));
    }

    public void testDefaultPaging() throws InterruptedException, NoSuchFieldException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, URISyntaxException {
        PageConfig pageConfig = new PageConfig();
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        RestfulPipeConfiguration pipeConfig = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        pipeConfig.requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create()));
        pipeConfig.pageConfig(pageConfig);
        Pipe dataPipe = pipeConfig.forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(dataPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                HashMap<String, String> headers = new HashMap<String, String>(1);
                headers.put("Link", "<http://example.com/TheBook/chapter2>; rel=\"previous\";title=\"previous chapter\",<http://example.com/TheBook/chapter3>; rel=\"next\";title=\"next chapter\"");
                HttpStubProvider provider = new HttpStubProvider(RestAdapterTest.this.url, new HeaderAndBody(RestAdapterTest.SERIALIZED_POINTS.getBytes(), headers));
                return provider;
            }
        });
        ReadFilter onePageFilter = new ReadFilter();
        onePageFilter.setLimit(Integer.valueOf(1));
        List resultList = this.runRead(dataPipe, onePageFilter);
        RestAdapterTest.assertTrue((boolean)(resultList instanceof PagedList));
        WrappingPagedList pagedList = (WrappingPagedList)resultList;
        RestAdapterTest.assertEquals((Object)new URI("http://example.com/TheBook/chapter3"), (Object)pagedList.getNextFilter().getLinkUri());
        RestAdapterTest.assertEquals((Object)new URI("http://example.com/TheBook/chapter2"), (Object)pagedList.getPreviousFilter().getLinkUri());
    }

    public void testBuildPagedResultsFromHeaders() throws Exception {
        PageConfig pageConfig = new PageConfig();
        pageConfig.setMetadataLocation((MetadataLocation)PageConfig.MetadataLocations.HEADERS);
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        config.pageConfig(pageConfig);
        RestAdapter adapter = new RestAdapter(Data.class, this.url, config);
        ArrayList list = new ArrayList();
        HeaderAndBody response = new HeaderAndBody(new byte[0], (Map)new HashMap<String, Object>(){
            {
                this.put("next", "chapter3");
                this.put("previous", "chapter2");
            }
        });
        JSONObject where = new JSONObject();
        Method method = adapter.getClass().getDeclaredMethod("computePagedList", List.class, HeaderAndBody.class, JSONObject.class, Pipe.class);
        method.setAccessible(true);
        WrappingPagedList pagedList = (WrappingPagedList)method.invoke((Object)adapter, list, response, where, adapter);
        RestAdapterTest.assertEquals((Object)new URI("http://server.com/context/chapter3"), (Object)pagedList.getNextFilter().getLinkUri());
        RestAdapterTest.assertEquals((Object)new URI("http://server.com/context/chapter2"), (Object)pagedList.getPreviousFilter().getLinkUri());
    }

    public void testBuildPagedResultsFromBody() throws Exception {
        PageConfig pageConfig = new PageConfig();
        pageConfig.setMetadataLocation((MetadataLocation)PageConfig.MetadataLocations.BODY);
        pageConfig.setNextIdentifier("pages.next");
        pageConfig.setPreviousIdentifier("pages.previous");
        RestfulPipeConfiguration config = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(this.url);
        config.pageConfig(pageConfig);
        RestAdapter adapter = (RestAdapter)config.forClass(Data.class);
        ArrayList list = new ArrayList();
        HeaderAndBody response = new HeaderAndBody("{\"pages\":{\"next\":\"chapter3\",\"previous\":\"chapter2\"}}".getBytes(), new HashMap());
        JSONObject where = new JSONObject();
        Method method = adapter.getClass().getDeclaredMethod("computePagedList", List.class, HeaderAndBody.class, JSONObject.class, Pipe.class);
        method.setAccessible(true);
        WrappingPagedList pagedList = (WrappingPagedList)method.invoke((Object)adapter, list, response, where, adapter);
        RestAdapterTest.assertEquals((Object)new URI("http://server.com/context/chapter3"), (Object)pagedList.getNextFilter().getLinkUri());
        RestAdapterTest.assertEquals((Object)new URI("http://server.com/context/chapter2"), (Object)pagedList.getPreviousFilter().getLinkUri());
    }

    public void testRunTimeout() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        URL aerogearserverUrl = new URL("https://controller-aerogear.rhcloud.com/aerogear-controller-demo/");
        RestfulPipeConfiguration pipeConfig = ((RestfulPipeConfiguration)PipeManager.config((String)"listClassId", RestfulPipeConfiguration.class)).withUrl(aerogearserverUrl);
        pipeConfig.timeout(Integer.valueOf(1));
        RestAdapter adapter = (RestAdapter)pipeConfig.forClass(Data.class);
        final AtomicBoolean onFailCalled = new AtomicBoolean(false);
        final AtomicReference exceptionReference = new AtomicReference();
        adapter.read((Callback)new Callback<List<Data>>(){

            public void onSuccess(List<Data> data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                onFailCalled.set(true);
                exceptionReference.set(e);
                latch.countDown();
            }
        });
        latch.await(50000L, TimeUnit.MILLISECONDS);
        RestAdapterTest.assertTrue((boolean)onFailCalled.get());
        RestAdapterTest.assertEquals(SocketTimeoutException.class, ((Exception)exceptionReference.get()).getCause().getClass());
    }

    private <T> List<T> runRead(Pipe<T> restPipe) throws InterruptedException {
        return this.runRead(restPipe, null);
    }

    private <T> List<T> runRead(Pipe<T> restPipe, ReadFilter readFilter) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean hasException = new AtomicBoolean(false);
        final AtomicReference resultRef = new AtomicReference();
        restPipe.read(readFilter, new Callback<List<T>>(){

            public void onSuccess(List<T> data) {
                resultRef.set(data);
                latch.countDown();
            }

            public void onFailure(Exception e) {
                hasException.set(true);
                Logger.getLogger(RestAdapterTest.class.getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)hasException.get());
        return (List)resultRef.get();
    }

    private <T> List<T> runReadForException(Pipe<T> restPipe, ReadFilter readFilter) throws InterruptedException, Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean hasException = new AtomicBoolean(false);
        final AtomicReference exceptionref = new AtomicReference();
        restPipe.read(readFilter, new Callback<List<T>>(){

            public void onSuccess(List<T> data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                hasException.set(true);
                exceptionref.set(e);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)hasException.get());
        throw (Exception)exceptionref.get();
    }

    private static class PointTypeAdapter
    implements InstanceCreator,
    JsonSerializer,
    JsonDeserializer {
        private PointTypeAdapter() {
        }

        public Object createInstance(Type type) {
            return new Point();
        }

        public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("x", (Number)((Point)src).x);
            object.addProperty("y", (Number)((Point)src).y);
            return object;
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Point(json.getAsJsonObject().getAsJsonPrimitive("x").getAsInt(), json.getAsJsonObject().getAsJsonPrimitive("y").getAsInt());
        }
    }

    public static final class ListClassId {
        List<Point> points = new ArrayList<Point>(10);
        @RecordId
        String id = "1";

        public ListClassId(boolean build) {
            if (build) {
                for (int i = 0; i < 10; ++i) {
                    this.points.add(new Point(i, i * 2));
                }
            }
        }

        public ListClassId() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id2) {
            this.id = id2;
        }

        public boolean equals(Object obj) {
            try {
                return this.points.equals(((ListClassId)obj).points);
            }
            catch (Throwable ignore) {
                return false;
            }
        }
    }
}

