/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.RecordId;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.helper.UnitTestUtils;
import org.jboss.aerogear.android.impl.http.HttpStubProvider;
import org.jboss.aerogear.android.impl.pipeline.GsonRequestBuilder;
import org.jboss.aerogear.android.impl.pipeline.RestfulPipeConfiguration;
import org.jboss.aerogear.android.impl.pipeline.loader.support.SupportReadLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.support.SupportRemoveLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.support.SupportSaveLoader;
import org.jboss.aerogear.android.impl.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.impl.util.VoidCallback;
import org.jboss.aerogear.android.pipe.test.MainFragmentActivity;
import org.jboss.aerogear.android.pipeline.LoaderPipe;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.PipeManager;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.support.AbstractSupportFragmentCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

@TargetApi(value=11)
public class SupportLoaderAdapterTest
extends PatchedActivityInstrumentationTestCase<MainFragmentActivity> {
    private static final String SERIALIZED_POINTS = "{\"points\":[{\"x\":0,\"y\":0},{\"x\":1,\"y\":2},{\"x\":2,\"y\":4},{\"x\":3,\"y\":6},{\"x\":4,\"y\":8},{\"x\":5,\"y\":10},{\"x\":6,\"y\":12},{\"x\":7,\"y\":14},{\"x\":8,\"y\":16},{\"x\":9,\"y\":18}],\"id\":\"1\"}";
    private URL url;

    public SupportLoaderAdapterTest() {
        super(MainFragmentActivity.class);
    }

    @Override
    public void setUp() throws MalformedURLException, Exception {
        super.setUp();
        this.url = new URL("http://server.com/context/");
    }

    public void testSingleObjectRead() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.url, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.url).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.get((String)config.getName(), (FragmentActivity)((FragmentActivity)this.getActivity()));
        adapter = (LoaderPipe)Mockito.spy((Object)adapter);
        adapter.read((Callback)new VoidCallback());
        ArgumentCaptor bundlerCaptor = ArgumentCaptor.forClass(Bundle.class);
        ((LoaderManager.LoaderCallbacks)Mockito.verify((Object)((LoaderManager.LoaderCallbacks)adapter))).onCreateLoader(Mockito.anyInt(), (Bundle)bundlerCaptor.capture());
        Bundle bundle = (Bundle)bundlerCaptor.getValue();
        SupportLoaderAdapterTest.assertNotNull((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK"));
        SupportLoaderAdapterTest.assertTrue((boolean)(bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK") instanceof VoidCallback));
        SupportLoaderAdapterTest.assertNotNull((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD"));
        SupportLoaderAdapterTest.assertTrue((boolean)((Enum)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD")).name().equals("READ"));
        SupportLoaderAdapterTest.assertNull((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID"));
    }

    public void testReadCallbackFailsWithIncompatibleType() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.url, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.url).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.get((String)config.getName(), (FragmentActivity)((FragmentActivity)this.getActivity()));
        try {
            adapter.read((Callback)new AbstractSupportFragmentCallback<List<ListClassId>>(new Object[0]){
                private static final long serialVersionUID = 1L;

                public void onSuccess(List<ListClassId> data) {
                }

                public void onFailure(Exception e) {
                }
            });
        }
        catch (Exception e) {
            return;
        }
        SupportLoaderAdapterTest.fail((String)"Incorrect callback should throw exception.");
    }

    public void testSaveCallbackFailsWithIncompatibleType() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.url, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.url).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.get((String)config.getName(), (FragmentActivity)((FragmentActivity)this.getActivity()));
        try {
            adapter.save((Object)new ListClassId(true), (Callback)new AbstractSupportFragmentCallback<ListClassId>(new Object[0]){
                private static final long serialVersionUID = 1L;

                public void onSuccess(ListClassId data) {
                }

                public void onFailure(Exception e) {
                }
            });
        }
        catch (Exception e) {
            return;
        }
        SupportLoaderAdapterTest.fail((String)"Incorrect callback should throw exception.");
    }

    public void testDeleteCallbackFailsWithIncompatibleType() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.url, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.url).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.get((String)config.getName(), (FragmentActivity)((FragmentActivity)this.getActivity()));
        try {
            adapter.remove("1", (Callback)new AbstractSupportFragmentCallback<Void>(new Object[0]){
                private static final long serialVersionUID = 1L;

                public void onSuccess(Void data) {
                }

                public void onFailure(Exception e) {
                }
            });
        }
        catch (Exception e) {
            return;
        }
        SupportLoaderAdapterTest.fail((String)"Incorrect callback should throw exception.");
    }

    public void testSingleObjectDelete() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        final HttpStubProvider provider = (HttpStubProvider)Mockito.mock(HttpStubProvider.class);
        Mockito.when((Object)provider.getUrl()).thenReturn((Object)this.url);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.url).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.get((String)config.getName(), (FragmentActivity)((FragmentActivity)this.getActivity()));
        adapter = (LoaderPipe)Mockito.spy((Object)adapter);
        ArgumentCaptor bundlerCaptor = ArgumentCaptor.forClass(Bundle.class);
        adapter.remove("1", (Callback)new VoidCallback());
        ((LoaderManager.LoaderCallbacks)Mockito.verify((Object)((LoaderManager.LoaderCallbacks)adapter))).onCreateLoader(Mockito.anyInt(), (Bundle)bundlerCaptor.capture());
        Bundle bundle = (Bundle)bundlerCaptor.getValue();
        SupportLoaderAdapterTest.assertNotNull((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK"));
        SupportLoaderAdapterTest.assertTrue((boolean)(bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK") instanceof VoidCallback));
        SupportLoaderAdapterTest.assertNotNull((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD"));
        SupportLoaderAdapterTest.assertTrue((boolean)((Enum)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD")).name().equals("REMOVE"));
        SupportLoaderAdapterTest.assertNotNull((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID"));
        SupportLoaderAdapterTest.assertEquals((Object)"1", (Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID"));
    }

    public void testMultipleCallsToLoadCallDeliver() {
        PipeHandler handler = (PipeHandler)Mockito.mock(PipeHandler.class);
        final AtomicBoolean called = new AtomicBoolean(false);
        Mockito.when((Object)handler.onRawReadWithFilter((ReadFilter)Matchers.any(), (Pipe)Matchers.any())).thenReturn((Object)new HeaderAndBody(new byte[0], new HashMap()));
        SupportReadLoader loader = new SupportReadLoader((Context)this.getActivity(), null, handler, null, null){

            public void deliverResult(Object data) {
                called.set(true);
            }

            public void forceLoad() {
                throw new IllegalStateException("Should not be called");
            }

            public void onStartLoading() {
                super.onStartLoading();
            }
        };
        loader.loadInBackground();
        UnitTestUtils.callMethod(loader, "onStartLoading");
        SupportLoaderAdapterTest.assertTrue((boolean)called.get());
    }

    public void testMultipleCallsToSaveCallDeliver() {
        PipeHandler handler = (PipeHandler)Mockito.mock(PipeHandler.class);
        final AtomicBoolean called = new AtomicBoolean(false);
        Mockito.when((Object)handler.onRawSave(Matchers.anyString(), (byte[])Matchers.anyObject())).thenReturn((Object)new HeaderAndBody(new byte[0], new HashMap()));
        SupportSaveLoader loader = new SupportSaveLoader((Context)this.getActivity(), null, handler, null, null){

            public void deliverResult(Object data) {
                called.set(true);
            }

            public void forceLoad() {
                throw new IllegalStateException("Should not be called");
            }

            public void onStartLoading() {
                super.onStartLoading();
            }
        };
        loader.loadInBackground();
        UnitTestUtils.callMethod(loader, "onStartLoading");
        SupportLoaderAdapterTest.assertTrue((boolean)called.get());
    }

    public void testMultipleCallsToRemoveCallDeliver() {
        PipeHandler handler = (PipeHandler)Mockito.mock(PipeHandler.class);
        final AtomicBoolean called = new AtomicBoolean(false);
        Mockito.when((Object)handler.onRawReadWithFilter((ReadFilter)Matchers.any(), (Pipe)Matchers.any())).thenReturn((Object)new HeaderAndBody("[]".getBytes(), new HashMap()));
        SupportRemoveLoader loader = new SupportRemoveLoader((Context)this.getActivity(), null, handler, null){

            public void deliverResult(Object data) {
                called.set(true);
            }

            public void forceLoad() {
                throw new IllegalStateException("Should not be called");
            }

            public void onStartLoading() {
                super.onStartLoading();
            }
        };
        loader.loadInBackground();
        UnitTestUtils.callMethod(loader, "onStartLoading");
        SupportLoaderAdapterTest.assertTrue((boolean)called.get());
    }

    public static final class ListClassId {
        List<Point> points = new ArrayList<Point>(10);
        @RecordId
        String id = "1";

        public ListClassId(boolean build) {
            if (build) {
                for (int i = 0; i < 10; ++i) {
                    this.points.add(new Point(i, i * 2));
                }
            }
        }

        public ListClassId() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id2) {
            this.id = id2;
        }

        public boolean equals(Object obj) {
            try {
                return this.points.equals(((ListClassId)obj).points);
            }
            catch (Throwable ignore) {
                return false;
            }
        }
    }

    private static class PointTypeAdapter
    implements InstanceCreator,
    JsonSerializer,
    JsonDeserializer {
        private PointTypeAdapter() {
        }

        public Object createInstance(Type type) {
            return new Point();
        }

        public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("x", (Number)((Point)src).x);
            object.addProperty("y", (Number)((Point)src).y);
            return object;
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Point(json.getAsJsonObject().getAsJsonPrimitive("x").getAsInt(), json.getAsJsonObject().getAsJsonPrimitive("y").getAsInt());
        }
    }
}

