/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.test.loader;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.support.test.runner.AndroidJUnit4;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.hamcrest.Matcher;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.core.ReadFilter;
import org.jboss.aerogear.android.core.RecordId;
import org.jboss.aerogear.android.pipe.LoaderPipe;
import org.jboss.aerogear.android.pipe.Pipe;
import org.jboss.aerogear.android.pipe.PipeHandler;
import org.jboss.aerogear.android.pipe.PipeManager;
import org.jboss.aerogear.android.pipe.RequestBuilder;
import org.jboss.aerogear.android.pipe.callback.AbstractFragmentCallback;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.pipe.http.HttpProviderFactory;
import org.jboss.aerogear.android.pipe.loader.LoaderAdapter;
import org.jboss.aerogear.android.pipe.loader.ReadLoader;
import org.jboss.aerogear.android.pipe.loader.RemoveLoader;
import org.jboss.aerogear.android.pipe.loader.SaveLoader;
import org.jboss.aerogear.android.pipe.rest.RestfulPipeConfiguration;
import org.jboss.aerogear.android.pipe.rest.gson.GsonRequestBuilder;
import org.jboss.aerogear.android.pipe.rest.multipart.MultipartRequestBuilder;
import org.jboss.aerogear.android.pipe.test.MainActivity;
import org.jboss.aerogear.android.pipe.test.helper.Data;
import org.jboss.aerogear.android.pipe.test.http.HttpStubProvider;
import org.jboss.aerogear.android.pipe.test.util.ObjectVarArgsMatcher;
import org.jboss.aerogear.android.pipe.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.pipe.test.util.UnitTestUtils;
import org.json.JSONObject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=AndroidJUnit4.class)
@TargetApi(value=11)
public class LoaderAdapterTest
extends PatchedActivityInstrumentationTestCase {
    private static final String TAG = LoaderAdapterTest.class.getSimpleName();
    private static final String SERIALIZED_POINTS = "{\"points\":[{\"x\":0,\"y\":0},{\"x\":1,\"y\":2},{\"x\":2,\"y\":4},{\"x\":3,\"y\":6},{\"x\":4,\"y\":8},{\"x\":5,\"y\":10},{\"x\":6,\"y\":12},{\"x\":7,\"y\":14},{\"x\":8,\"y\":16},{\"x\":9,\"y\":18}],\"id\":\"1\"}";
    private URL url;
    private URL listUrl;

    public LoaderAdapterTest() {
        super(MainActivity.class);
    }

    @Before
    public void setUp() throws MalformedURLException, Exception {
        this.url = new URL("http://server.com/context/");
        this.listUrl = new URL("http://server.com/context/ListClassId");
    }

    @Test
    public void testSingleObjectRead() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.listUrl, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.listUrl).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.getPipe((String)config.getName(), (Activity)this.getActivity());
        List result = this.runRead((Pipe)adapter);
        List<Point> returnedPoints = ((ListClassId)result.get((int)0)).points;
        Assert.assertEquals((int)10, (int)returnedPoints.size());
    }

    @Test
    public void testReadCallbackFailsWithIncompatibleType() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.listUrl, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.listUrl).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.getPipe((String)config.getName(), (Activity)this.getActivity());
        try {
            adapter.read((Callback)new AbstractFragmentCallback<List<ListClassId>>(new Object[0]){
                private static final long serialVersionUID = 1L;

                public void onSuccess(List<ListClassId> data) {
                }

                public void onFailure(Exception e) {
                }
            });
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"Incorrect callback should throw exception.");
    }

    @Test
    public void testSaveCallbackFailsWithIncompatibleType() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.listUrl, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.listUrl).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.getPipe((String)config.getName(), (Activity)this.getActivity());
        try {
            adapter.save((Object)new ListClassId(true), (Callback)new AbstractFragmentCallback<ListClassId>(new Object[0]){
                private static final long serialVersionUID = 1L;

                public void onSuccess(ListClassId data) {
                }

                public void onFailure(Exception e) {
                }
            });
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"Incorrect callback should throw exception.");
    }

    @Test
    public void testDeleteCallbackFailsWithIncompatibleType() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        HeaderAndBody response = new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap());
        final HttpStubProvider provider = new HttpStubProvider(this.listUrl, response);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.listUrl).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.getPipe((String)config.getName(), (Activity)this.getActivity());
        try {
            adapter.remove("1", (Callback)new AbstractFragmentCallback<Void>(new Object[0]){
                private static final long serialVersionUID = 1L;

                public void onSuccess(Void data) {
                }

                public void onFailure(Exception e) {
                }
            });
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"Incorrect callback should throw exception.");
    }

    @Test
    public void testSingleObjectSave() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        final HttpStubProvider provider = (HttpStubProvider)Mockito.mock(HttpStubProvider.class);
        Mockito.when((Object)provider.getUrl()).thenReturn((Object)this.listUrl);
        Mockito.when((Object)provider.post((byte[])Matchers.anyObject())).thenReturn((Object)new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap()));
        Mockito.when((Object)provider.put((String)Matchers.any(String.class), (byte[])Matchers.anyObject())).thenReturn((Object)new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap()));
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.listUrl).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.getPipe((String)config.getName(), (Activity)this.getActivity());
        this.runSave((Pipe<ListClassId>)adapter);
        ((HttpStubProvider)Mockito.verify((Object)provider)).put((String)Matchers.any(String.class), (byte[])Matchers.anyObject());
    }

    @Test
    public void testSingleObjectMultipartSave() throws Exception {
        final HttpStubProvider provider = (HttpStubProvider)Mockito.mock(HttpStubProvider.class);
        Mockito.when((Object)provider.getUrl()).thenReturn((Object)this.url);
        Mockito.when((Object)provider.post((byte[])Matchers.anyObject())).thenReturn((Object)new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap()));
        Mockito.when((Object)provider.put((String)Matchers.any(String.class), (byte[])Matchers.anyObject())).thenReturn((Object)new HeaderAndBody(SERIALIZED_POINTS.getBytes(), new HashMap()));
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"MultiPartData", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.url).requestBuilder((RequestBuilder)new MultipartRequestBuilder()).forClass(MultiPartData.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.getPipe((String)config.getName(), (Activity)this.getActivity());
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean hasException = new AtomicBoolean(false);
        adapter.save((Object)new MultiPartData(), (Callback)new Callback<MultiPartData>(){
            private static final long serialVersionUID = 1L;

            public void onSuccess(MultiPartData data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                hasException.set(true);
                Logger.getLogger(LoaderAdapterTest.class.getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)hasException.get());
        ((HttpStubProvider)Mockito.verify((Object)provider)).put((String)Matchers.any(String.class), (byte[])Matchers.anyObject());
    }

    @Test
    public void testSingleObjectDelete() throws Exception {
        GsonBuilder builder = new GsonBuilder().registerTypeAdapter(Point.class, (Object)new PointTypeAdapter());
        final HttpStubProvider provider = (HttpStubProvider)Mockito.mock(HttpStubProvider.class);
        Mockito.when((Object)provider.getUrl()).thenReturn((Object)this.listUrl);
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"ListClassId", RestfulPipeConfiguration.class);
        Pipe restPipe = config.withUrl(this.listUrl).requestBuilder((RequestBuilder)new GsonRequestBuilder(builder.create())).forClass(ListClassId.class);
        Object restRunner = UnitTestUtils.getPrivateField(restPipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", new Provider<HttpProvider>(){

            public HttpProvider get(Object ... in) {
                return provider;
            }
        });
        LoaderPipe adapter = PipeManager.getPipe((String)config.getName(), (Activity)this.getActivity());
        this.runRemove((Pipe)adapter, "1");
        ((HttpStubProvider)Mockito.verify((Object)provider)).delete((String)Matchers.eq((Object)"1"));
    }

    @Test
    public void testMultipleCallsToLoadCallDeliver() {
        PipeHandler handler = (PipeHandler)Mockito.mock(PipeHandler.class);
        final AtomicBoolean called = new AtomicBoolean(false);
        Mockito.when((Object)handler.onRawReadWithFilter((ReadFilter)Matchers.any(), (Pipe)Matchers.any())).thenReturn((Object)new HeaderAndBody(new byte[0], new HashMap()));
        ReadLoader loader = new ReadLoader((Context)this.getActivity(), null, handler, null, null){

            public void deliverResult(Object data) {
                called.set(true);
            }

            public void forceLoad() {
                throw new IllegalStateException("Should not be called");
            }

            public void onStartLoading() {
                super.onStartLoading();
            }
        };
        loader.loadInBackground();
        UnitTestUtils.callMethod(loader, "onStartLoading");
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void testMultipleCallsToSaveCallDeliver() {
        PipeHandler handler = (PipeHandler)Mockito.mock(PipeHandler.class);
        final AtomicBoolean called = new AtomicBoolean(false);
        Mockito.when((Object)handler.onRawSave(Matchers.anyString(), (byte[])Matchers.anyObject())).thenReturn((Object)new HeaderAndBody(new byte[0], new HashMap()));
        SaveLoader loader = new SaveLoader((Context)this.getActivity(), null, handler, null, null){

            public void deliverResult(Object data) {
                called.set(true);
            }

            public void forceLoad() {
                throw new IllegalStateException("Should not be called");
            }

            public void onStartLoading() {
                super.onStartLoading();
            }
        };
        loader.loadInBackground();
        UnitTestUtils.callMethod(loader, "onStartLoading");
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void testMultipleCallsToRemoveCallDeliver() {
        PipeHandler handler = (PipeHandler)Mockito.mock(PipeHandler.class);
        final AtomicBoolean called = new AtomicBoolean(false);
        Mockito.when((Object)handler.onRawReadWithFilter((ReadFilter)Matchers.any(), (Pipe)Matchers.any())).thenReturn((Object)new HeaderAndBody(new byte[0], new HashMap()));
        RemoveLoader loader = new RemoveLoader((Context)this.getActivity(), null, handler, null){

            public void deliverResult(Object data) {
                called.set(true);
            }

            public void forceLoad() {
                throw new IllegalStateException("Should not be called");
            }

            public void onStartLoading() {
                super.onStartLoading();
            }
        };
        loader.loadInBackground();
        UnitTestUtils.callMethod(loader, "onStartLoading");
        Assert.assertTrue((boolean)called.get());
    }

    private <T> List<T> runRead(Pipe<T> restPipe) throws InterruptedException {
        return this.runRead(restPipe, null);
    }

    private <T> List<T> runRead(Pipe<T> restPipe, ReadFilter readFilter) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean hasException = new AtomicBoolean(false);
        final AtomicReference resultRef = new AtomicReference();
        restPipe.read(readFilter, new Callback<List<T>>(){
            private static final long serialVersionUID = 1L;

            public void onSuccess(List<T> data) {
                resultRef.set(data);
                latch.countDown();
            }

            public void onFailure(Exception e) {
                hasException.set(true);
                Logger.getLogger(LoaderAdapterTest.class.getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)hasException.get());
        return (List)resultRef.get();
    }

    private <T> void runRemove(Pipe<T> restPipe, String id2) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean hasException = new AtomicBoolean(false);
        restPipe.remove(id2, (Callback)new Callback<Void>(){
            private static final long serialVersionUID = 1L;

            public void onSuccess(Void data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                hasException.set(true);
                Logger.getLogger(LoaderAdapterTest.class.getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)hasException.get());
    }

    private void runSave(Pipe<ListClassId> restPipe) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean hasException = new AtomicBoolean(false);
        restPipe.save((Object)new ListClassId(true), (Callback)new Callback<ListClassId>(){
            private static final long serialVersionUID = 1L;

            public void onSuccess(ListClassId data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                hasException.set(true);
                Logger.getLogger(LoaderAdapterTest.class.getSimpleName()).log(Level.SEVERE, e.getMessage(), e);
                latch.countDown();
            }
        });
        latch.await(2L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)hasException.get());
    }

    @Test
    public void testRunReadWithFilter() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        HttpProviderFactory factory = (HttpProviderFactory)Mockito.mock(HttpProviderFactory.class);
        Mockito.when((Object)factory.get(new Object[]{Matchers.anyObject()})).thenReturn(Mockito.mock(HttpProvider.class));
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"data", RestfulPipeConfiguration.class);
        Pipe pipe = config.withUrl(this.url).forClass(Data.class);
        Object restRunner = UnitTestUtils.getPrivateField(pipe, "restRunner");
        UnitTestUtils.setPrivateField(restRunner, "httpProviderFactory", factory);
        ReadFilter filter = new ReadFilter();
        filter.setLimit(Integer.valueOf(10));
        filter.setWhere(new JSONObject("{\"model\":\"BMW\"}"));
        LoaderAdapter adapter = (LoaderAdapter)PipeManager.getPipe((String)"data", (Activity)this.getActivity());
        adapter.read(filter, (Callback)new Callback<List<Data>>(){
            private static final long serialVersionUID = 1L;

            public void onSuccess(List<Data> data) {
                latch.countDown();
            }

            public void onFailure(Exception e) {
                latch.countDown();
                Logger.getLogger(this.getClass().getSimpleName()).log(Level.SEVERE, TAG, e);
            }
        });
        latch.await(60L, TimeUnit.SECONDS);
        ((HttpProviderFactory)Mockito.verify((Object)factory)).get(new Object[]{Mockito.argThat((Matcher)new ObjectVarArgsMatcher(new URL("http://server.com/context?limit=10&model=BMW"), 60000))});
    }

    @Test
    public void testResetWithoutPipeIds() throws NoSuchFieldException, IllegalAccessException {
        RestfulPipeConfiguration config = (RestfulPipeConfiguration)PipeManager.config((String)"data", RestfulPipeConfiguration.class);
        Pipe pipe = config.withUrl(this.url).forClass(Data.class);
        LoaderAdapter loaderPipe = new LoaderAdapter((Activity)this.getActivity(), pipe, "loaderPipeForTest");
        loaderPipe.reset();
        Map idsForNamedPipes = (Map)UnitTestUtils.getPrivateField(loaderPipe, "idsForNamedPipes");
        Assert.assertEquals((String)"Should be 1", (int)1, (int)idsForNamedPipes.size());
        Assert.assertNotNull((String)"Should not null", idsForNamedPipes.get("loaderPipeForTest"));
        Assert.assertEquals((String)"Should be empty", (int)0, (int)((List)idsForNamedPipes.get("loaderPipeForTest")).size());
    }

    public static class MultiPartData {
        private byte[] byteArray = new byte[]{97, 98, 99, 100, 101, 102};
        private InputStream inputStream = new ByteArrayInputStream(this.byteArray);
        @RecordId
        private String string = "This is a String";

        public byte[] getByteArray() {
            return this.byteArray;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getString() {
            return this.string;
        }

        public void setByteArray(byte[] byteArray) {
            this.byteArray = byteArray;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void setString(String string2) {
            this.string = string2;
        }
    }

    public static final class ListClassId {
        List<Point> points = new ArrayList<Point>(10);
        @RecordId
        String id = "1";

        public ListClassId(boolean build) {
            if (build) {
                for (int i = 0; i < 10; ++i) {
                    this.points.add(new Point(i, i * 2));
                }
            }
        }

        public ListClassId() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id2) {
            this.id = id2;
        }

        public boolean equals(Object obj) {
            try {
                return this.points.equals(((ListClassId)obj).points);
            }
            catch (Throwable ignore) {
                return false;
            }
        }
    }

    private static class PointTypeAdapter
    implements InstanceCreator,
    JsonSerializer,
    JsonDeserializer {
        private PointTypeAdapter() {
        }

        public Object createInstance(Type type) {
            return new Point();
        }

        public JsonElement serialize(Object src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("x", (Number)((Point)src).x);
            object.addProperty("y", (Number)((Point)src).y);
            return object;
        }

        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Point(json.getAsJsonObject().getAsJsonPrimitive("x").getAsInt(), json.getAsJsonObject().getAsJsonPrimitive("y").getAsInt());
        }
    }
}

