/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.pipe.test.http;

import android.support.test.runner.AndroidJUnit4;
import java.util.HashMap;
import org.jboss.aerogear.android.pipe.http.HeaderAndBody;
import org.jboss.aerogear.android.pipe.http.HttpException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=AndroidJUnit4.class)
public class HttpHelperTest {
    private static final byte[] SIMPLE_DATA = new byte[]{8, 6, 7, 5, 3, 0, 9};
    private static final String SAMPLE_MESSAGE = "SAMPLE_MESSAGE";
    private static final String SAMPLE_HEADER = "SAMPLE_HEADER";
    private static final String DEFAULT_MESSAGE = "The server returned the error code 404.";
    private static final int NOT_FOUND = 404;

    @Test
    public void constructsHttpException() {
        HttpException exception = new HttpException(SIMPLE_DATA, 404);
        HttpException exceptionWithMessage = new HttpException(SIMPLE_DATA, 404, SAMPLE_MESSAGE);
        Assert.assertNotSame((Object)SIMPLE_DATA, (Object)exception.getData());
        for (int i = 0; i < SIMPLE_DATA.length; ++i) {
            Assert.assertEquals((long)SIMPLE_DATA[i], (long)exception.getData()[i]);
        }
        Assert.assertEquals((long)404L, (long)exception.getStatusCode());
        Assert.assertEquals((Object)DEFAULT_MESSAGE, (Object)exception.getMessage());
        Assert.assertEquals((Object)SAMPLE_MESSAGE, (Object)exceptionWithMessage.getMessage());
    }

    @Test
    public void constructHeaderAndBody() {
        HeaderAndBody headerAndBody = new HeaderAndBody(SIMPLE_DATA, new HashMap());
        headerAndBody.setHeader(SAMPLE_HEADER, (Object)SAMPLE_MESSAGE);
        Assert.assertEquals((Object)SAMPLE_MESSAGE, (Object)headerAndBody.getHeader(SAMPLE_HEADER));
    }
}

