/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test;

import android.support.test.runner.AndroidJUnit4;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.jboss.aerogear.android.unifiedpush.PushConfiguration;
import org.jboss.aerogear.android.unifiedpush.PushRegistrar;
import org.jboss.aerogear.android.unifiedpush.RegistrarManager;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushConfiguration;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushRegistrar;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=AndroidJUnit4.class)
public class RegistrationsTest
extends PatchedActivityInstrumentationTestCase {
    private static final String PUSH = "push";

    public RegistrationsTest() {
        super(MainActivity.class);
    }

    @Test
    public void testDefaultConfig() throws URISyntaxException {
        AeroGearFCMPushConfiguration config = ((AeroGearFCMPushConfiguration)RegistrarManager.config((String)PUSH, AeroGearFCMPushConfiguration.class)).setPushServerURI(new URI("http://testreg.com")).setSenderId("TestID").setVariantID("VariantID").setSecret("secret");
        config.asRegistrar();
        PushRegistrar registrar = RegistrarManager.getRegistrar((String)PUSH);
        Assert.assertNotNull((Object)registrar);
        Assert.assertTrue((boolean)(registrar instanceof AeroGearFCMPushRegistrar));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailsOnUnsupportedType() {
        PushConfiguration config = RegistrarManager.config((String)PUSH, BrokenConfig.class);
    }

    @Test
    public void testCustomFactoryType() {
        RegistrarManager.registerConfigurationProvider(StubConfig.class, (ConfigurationProvider)new ConfigurationProvider<StubConfig>(){

            public StubConfig newConfiguration() {
                return new StubConfig();
            }
        });
        StubConfig config = (StubConfig)RegistrarManager.config((String)PUSH, StubConfig.class);
        config.asRegistrar();
        Assert.assertNotNull((Object)RegistrarManager.getRegistrar((String)PUSH));
        Assert.assertFalse((boolean)(RegistrarManager.getRegistrar((String)PUSH) instanceof AeroGearFCMPushRegistrar));
    }

    private static final class StubConfig
    extends PushConfiguration<StubConfig> {
        private StubConfig() {
        }

        protected PushRegistrar buildRegistrar() {
            return (PushRegistrar)Mockito.mock(PushRegistrar.class);
        }
    }

    private static final class BrokenConfig
    extends PushConfiguration<BrokenConfig> {
        private BrokenConfig() {
        }

        protected PushRegistrar buildRegistrar() {
            return (PushRegistrar)Mockito.mock(PushRegistrar.class);
        }
    }
}

