/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush.test.fcm;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.test.runner.AndroidJUnit4;
import com.google.firebase.messaging.FirebaseMessaging;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.Provider;
import org.jboss.aerogear.android.pipe.http.HttpProvider;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushConfiguration;
import org.jboss.aerogear.android.unifiedpush.fcm.AeroGearFCMPushRegistrar;
import org.jboss.aerogear.android.unifiedpush.fcm.FCMSharedPreferenceProvider;
import org.jboss.aerogear.android.unifiedpush.fcm.UnifiedPushInstanceIDListenerService;
import org.jboss.aerogear.android.unifiedpush.test.MainActivity;
import org.jboss.aerogear.android.unifiedpush.test.fcm.AeroGearFCMPushRegistrarTest;
import org.jboss.aerogear.android.unifiedpush.test.util.PatchedActivityInstrumentationTestCase;
import org.jboss.aerogear.android.unifiedpush.test.util.UnitTestUtils;
import org.jboss.aerogear.android.unifiedpush.test.util.VoidCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=AndroidJUnit4.class)
public class InstanceIdListenerTests
extends PatchedActivityInstrumentationTestCase {
    private static final String TEST_SENDER_ID = "272275396485";
    private static final String TEST_REGISTRAR_PREFERENCES_KEY = "org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushRegistrar:272275396485";
    private static final String TEST_SENDER_PASSWORD = "Password";
    private static final String TEST_SENDER_VARIANT = "Variant";

    public InstanceIdListenerTests() {
        super(MainActivity.class);
    }

    @Before
    public void fakeRegister() throws Exception {
        AeroGearFCMPushConfiguration config = new AeroGearFCMPushConfiguration().setSenderId(TEST_SENDER_ID).setVariantID(TEST_SENDER_VARIANT).setSecret(TEST_SENDER_PASSWORD).setPushServerURI(new URI("https://testuri"));
        AeroGearFCMPushRegistrar registrar = (AeroGearFCMPushRegistrar)config.asRegistrar();
        CountDownLatch latch = new CountDownLatch(1);
        AeroGearFCMPushRegistrarTest.StubHttpProvider provider = new AeroGearFCMPushRegistrarTest.StubHttpProvider();
        UnitTestUtils.setPrivateField(registrar, "httpProviderProvider", provider);
        VoidCallback callback = new VoidCallback(latch);
        UnitTestUtils.setPrivateField(registrar, "firebaseInstanceIdProvider", new AeroGearFCMPushRegistrarTest.StubInstanceIDProvider());
        final FirebaseMessaging mockPubSub = (FirebaseMessaging)Mockito.mock(FirebaseMessaging.class);
        ((FirebaseMessaging)Mockito.doNothing().when((Object)mockPubSub)).unsubscribeFromTopic(Matchers.anyString());
        ((FirebaseMessaging)Mockito.doNothing().when((Object)mockPubSub)).subscribeToTopic(Matchers.anyString());
        Provider<FirebaseMessaging> gcmPubSubProvider = new Provider<FirebaseMessaging>(){

            public FirebaseMessaging get(Object ... in) {
                return mockPubSub;
            }
        };
        UnitTestUtils.setPrivateField(registrar, "firebaseMessagingProvider", gcmPubSubProvider);
        registrar.register((Context)super.getActivity(), (Callback)callback);
        if (!latch.await(30L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Latch wasn't called");
        }
        if (callback.exception != null) {
            throw callback.exception;
        }
        Assert.assertNotNull((Object)new FCMSharedPreferenceProvider().get(new Object[]{this.getActivity()}).getString(TEST_REGISTRAR_PREFERENCES_KEY, null));
    }

    @Test
    public void refreshIntentSendsCallsRefresh() throws Exception {
        AeroGearFCMPushRegistrarTest.StubHttpProvider httpProvider = new AeroGearFCMPushRegistrarTest.StubHttpProvider();
        UnifiedPushInstanceIDListenerService service = new UnifiedPushInstanceIDListenerService();
        UnitTestUtils.setPrivateField(service, "httpProviderProvider", httpProvider);
        UnitTestUtils.setPrivateField(service, "sharedPreferencesProvider", new Provider<SharedPreferences>(){

            public SharedPreferences get(Object ... in) {
                return new FCMSharedPreferenceProvider().get(new Object[]{InstanceIdListenerTests.this.getActivity()});
            }
        });
        UnitTestUtils.setPrivateField(service, "instanceIdProvider", new AeroGearFCMPushRegistrarTest.StubInstanceIDProvider());
        service.onTokenRefresh();
        ((HttpProvider)Mockito.verify((Object)httpProvider.get(new Object[0]))).post(Matchers.anyString());
    }
}

