/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.security;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.core.ConfigurationProvider;
import org.jboss.aerogear.android.security.AbstractEncryptionConfiguration;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.OnEncryptionServiceCreatedListener;
import org.jboss.aerogear.android.security.keystore.KeyStoreBasedEncryptionConfiguration;
import org.jboss.aerogear.android.security.keystore.KeyStoreBasedEncryptionConfigurationProvider;
import org.jboss.aerogear.android.security.passphrase.PassphraseGeneratedEncryptionConfiguration;
import org.jboss.aerogear.android.security.passphrase.PassphraseGeneratedEncryptionConfigurationProvider;

public class SecurityManager {
    private static Map<String, EncryptionService> services = new HashMap<String, EncryptionService>();
    private static Map<Class<? extends AbstractEncryptionConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnEncryptionServiceCreatedListener onEncryptionServiceCreatedListener = new OnEncryptionServiceCreatedListener(){

        @Override
        public void onEncryptionServiceCreated(AbstractEncryptionConfiguration<?> configuration, EncryptionService service) {
            services.put(configuration.getName(), service);
        }
    };

    private SecurityManager() {
    }

    public static <CFG extends AbstractEncryptionConfiguration<CFG>> void registerConfigurationProvider(Class<CFG> configurationClass, ConfigurationProvider<CFG> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends AbstractEncryptionConfiguration<CFG>> CFG config(String name, Class<CFG> cryptoConfigurationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(cryptoConfigurationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((AbstractEncryptionConfiguration)provider.newConfiguration()).setName(name).addOnEncryptionServiceCreatedListener(onEncryptionServiceCreatedListener);
    }

    public static EncryptionService get(String name) {
        return services.get(name);
    }

    static {
        PassphraseGeneratedEncryptionConfigurationProvider passphraseCryptoConfigProvider = new PassphraseGeneratedEncryptionConfigurationProvider();
        SecurityManager.registerConfigurationProvider(PassphraseGeneratedEncryptionConfiguration.class, passphraseCryptoConfigProvider);
        KeyStoreBasedEncryptionConfigurationProvider digestConfigurationProvider = new KeyStoreBasedEncryptionConfigurationProvider();
        SecurityManager.registerConfigurationProvider(KeyStoreBasedEncryptionConfiguration.class, digestConfigurationProvider);
    }
}

