/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import java.io.Serializable;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.AeroGearCrypto;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.datamanager.StoreType;
import org.jboss.aerogear.android.impl.crypto.InvalidKeyException;
import org.jboss.aerogear.android.impl.datamanager.MemoryStore;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;
import org.jboss.aerogear.android.impl.util.CryptoUtils;
import org.jboss.aerogear.crypto.RandomUtils;
import org.jboss.aerogear.crypto.keys.PrivateKey;
import org.jboss.aerogear.crypto.password.Pbkdf2;

public class EncryptedMemoryStore<T>
implements Store<T> {
    private final MemoryStore<byte[]> memoryStore;
    private final CryptoUtils<T> cryptoUtils;

    public EncryptedMemoryStore(IdGenerator idGenerator, String passphrase, Class<T> modelClass) {
        this.memoryStore = new MemoryStore(idGenerator);
        byte[] iv = RandomUtils.randomBytes();
        byte[] salt = RandomUtils.randomBytes();
        byte[] rawPassword = new byte[]{};
        try {
            Pbkdf2 pbkdf2 = AeroGearCrypto.pbkdf2();
            rawPassword = pbkdf2.encrypt(passphrase, salt);
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        PrivateKey privateKey = new PrivateKey(rawPassword);
        this.cryptoUtils = new CryptoUtils(privateKey, iv, modelClass);
    }

    @Override
    public StoreType getType() {
        return StoreTypes.ENCRYPTED_MEMORY;
    }

    @Override
    public Collection<T> readAll() throws InvalidKeyException {
        Collection<byte[]> encryptedCollection = this.memoryStore.readAll();
        return this.cryptoUtils.decrypt(encryptedCollection);
    }

    @Override
    public T read(Serializable id) throws InvalidKeyException {
        byte[] encryptedItem = this.memoryStore.read(id);
        if (encryptedItem == null) {
            return null;
        }
        return (T)this.cryptoUtils.decrypt(encryptedItem);
    }

    @Override
    public List<T> readWithFilter(ReadFilter filter) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(T item) {
        Serializable idValue = this.memoryStore.getOrGenerateIdValue(item);
        this.memoryStore.save(idValue, this.cryptoUtils.encrypt(item));
    }

    @Override
    public void reset() {
        this.memoryStore.reset();
    }

    @Override
    public void remove(Serializable id) {
        this.memoryStore.remove(id);
    }

    @Override
    public boolean isEmpty() {
        return this.memoryStore.isEmpty();
    }
}

