/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.ConfigurationProvider;
import org.jboss.aerogear.android.datamanager.OnStoreCreatedListener;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.impl.datamanager.EncryptedMemoryStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.EncryptedMemoryStoreConfigurationProvider;
import org.jboss.aerogear.android.impl.datamanager.EncryptedSQLStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.EncryptedSQLStoreConfigurationProvider;
import org.jboss.aerogear.android.impl.datamanager.MemoryStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.MemoryStoreConfigurationProvider;
import org.jboss.aerogear.android.impl.datamanager.SQLStoreConfiguration;
import org.jboss.aerogear.android.impl.datamanager.SQLStoreConfigurationProvider;
import org.jboss.aerogear.android.impl.datamanager.StoreConfiguration;

public final class DataManager {
    private static Map<String, Store<?>> stores = new HashMap();
    private static Map<Class<? extends StoreConfiguration<?>>, ConfigurationProvider<?>> configurationProviderMap = new HashMap();
    private static OnStoreCreatedListener onStoreCreatedListener = new OnStoreCreatedListener(){

        @Override
        public void onStoreCreated(StoreConfiguration<?> configuration, Store<?> store) {
            stores.put(configuration.getName(), store);
        }
    };

    private DataManager() {
    }

    public static <CONFIGURATION extends StoreConfiguration<CONFIGURATION>> void registerConfigurationProvider(Class<CONFIGURATION> configurationClass, ConfigurationProvider<CONFIGURATION> provider) {
        configurationProviderMap.put(configurationClass, provider);
    }

    public static <CFG extends StoreConfiguration<CFG>> CFG config(String name, Class<CFG> storeImplementationClass) {
        ConfigurationProvider<?> provider = configurationProviderMap.get(storeImplementationClass);
        if (provider == null) {
            throw new IllegalArgumentException("Configuration not registered!");
        }
        return (CFG)((StoreConfiguration)provider.newConfiguration()).setName(name).addOnStoreCreatedListener(onStoreCreatedListener);
    }

    public static Store getStore(String name) {
        return stores.get(name);
    }

    static {
        DataManager.registerConfigurationProvider(MemoryStoreConfiguration.class, new MemoryStoreConfigurationProvider());
        DataManager.registerConfigurationProvider(SQLStoreConfiguration.class, new SQLStoreConfigurationProvider());
        DataManager.registerConfigurationProvider(EncryptedMemoryStoreConfiguration.class, new EncryptedMemoryStoreConfigurationProvider());
        DataManager.registerConfigurationProvider(EncryptedSQLStoreConfiguration.class, new EncryptedSQLStoreConfigurationProvider());
    }
}

