/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import org.jboss.aerogear.android.Config;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.impl.datamanager.DefaultIdGenerator;
import org.jboss.aerogear.android.impl.datamanager.EncryptedMemoryStore;
import org.jboss.aerogear.android.impl.datamanager.StoreConfiguration;

public final class EncryptedMemoryStoreConfiguration
extends StoreConfiguration<EncryptedMemoryStoreConfiguration>
implements Config<EncryptedMemoryStoreConfiguration> {
    private IdGenerator idGenerator = new DefaultIdGenerator();
    private String passphrase;
    private Class klass;

    public EncryptedMemoryStoreConfiguration withIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public EncryptedMemoryStoreConfiguration usingPassphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    public EncryptedMemoryStoreConfiguration forClass(Class klass) {
        this.klass = klass;
        return this;
    }

    @Override
    protected Store buildStore() {
        if (this.klass == null || this.passphrase == null) {
            throw new IllegalStateException("Klass and Passphrase are mandatory");
        }
        return new EncryptedMemoryStore(this.idGenerator, this.passphrase, this.klass);
    }
}

