/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store.memory;

import android.content.Context;
import org.jboss.aerogear.android.core.Config;
import org.jboss.aerogear.android.store.Store;
import org.jboss.aerogear.android.store.StoreConfiguration;
import org.jboss.aerogear.android.store.generator.DefaultIdGenerator;
import org.jboss.aerogear.android.store.generator.IdGenerator;
import org.jboss.aerogear.android.store.memory.EncryptedMemoryStore;

public final class EncryptedMemoryStoreConfiguration
extends StoreConfiguration<EncryptedMemoryStoreConfiguration>
implements Config<EncryptedMemoryStoreConfiguration> {
    private Context context;
    private IdGenerator idGenerator = new DefaultIdGenerator();
    private String password;

    public EncryptedMemoryStoreConfiguration withContext(Context context) {
        this.context = context;
        return this;
    }

    public EncryptedMemoryStoreConfiguration withIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
        return this;
    }

    public EncryptedMemoryStoreConfiguration usingPassword(String passphrase) {
        this.password = passphrase;
        return this;
    }

    @Override
    protected <TYPE> Store<TYPE> buildStore(Class<TYPE> klass) {
        if (this.context == null || klass == null || this.password == null) {
            throw new IllegalStateException("Context, Klass and Passphrase are mandatory");
        }
        return new EncryptedMemoryStore<TYPE>(this.context, this.idGenerator, this.password, klass);
    }
}

