/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.InvalidKeyException;

public class CryptoEntityUtil<T> {
    private final EncryptionService encryptionService;
    private final byte[] IV;
    private final Class<T> modelClass;
    private final Gson gson;

    public CryptoEntityUtil(EncryptionService encryptionService, byte[] iv, Class<T> modelClass) {
        this(encryptionService, iv, modelClass, new GsonBuilder());
    }

    public CryptoEntityUtil(EncryptionService encryptionService, byte[] iv, Class<T> modelClass, GsonBuilder builder) {
        this.encryptionService = encryptionService;
        this.IV = iv;
        this.modelClass = modelClass;
        this.gson = builder.create();
    }

    public byte[] encrypt(T item) {
        String json = this.gson.toJson(item);
        byte[] message = json.getBytes();
        return this.encryptionService.encrypt(this.IV, message);
    }

    public T decrypt(byte[] data) {
        try {
            byte[] decryptedData = this.encryptionService.decrypt(this.IV, data);
            String json = new String(decryptedData);
            return (T)this.gson.fromJson(json, this.modelClass);
        }
        catch (RuntimeException e) {
            throw new InvalidKeyException(e);
        }
    }
}

