/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store.sql;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.AsyncTask;
import android.util.Log;
import android.util.Pair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.android.core.Callback;
import org.jboss.aerogear.android.core.ReadFilter;
import org.jboss.aerogear.android.core.reflection.Property;
import org.jboss.aerogear.android.core.reflection.Scan;
import org.jboss.aerogear.android.store.Store;
import org.jboss.aerogear.android.store.generator.DefaultIdGenerator;
import org.jboss.aerogear.android.store.generator.IdGenerator;

public class SQLStore<T>
extends SQLiteOpenHelper
implements Store<T> {
    private static final String TAG = SQLStore.class.getSimpleName();
    private final Class<T> klass;
    private final String className;
    private static final String CREATE_PROPERTIES_TABLE = "create table if not exists %s_property  ( _ID integer primary key autoincrement,  PARENT_ID text not null,  PROPERTY_NAME text not null,  PROPERTY_VALUE text )";
    private static final String CREATE_PROPERTIES_INDEXES = "create index  if not exists %s_property_name_index  ON %s_property (PROPERTY_NAME);create index if not exists %s_property_name_value_index  ON %s_property (PROPERTY_NAME, PROPERTY_VALUE) ;create index  if not exists %s_property_parent_index  ON %s_property (PARENT_ID);";
    private SQLiteDatabase database;
    private final Gson gson;
    private final IdGenerator generator;

    public SQLStore(Class<T> klass, Context context) {
        super(context, klass.getSimpleName(), null, 1);
        this.klass = klass;
        this.className = klass.getSimpleName();
        this.gson = new Gson();
        this.generator = new DefaultIdGenerator();
    }

    public SQLStore(Class<T> klass, Context context, GsonBuilder builder, IdGenerator generator) {
        super(context, klass.getSimpleName(), null, 1);
        this.klass = klass;
        this.className = klass.getSimpleName();
        this.gson = builder.create();
        this.generator = generator;
    }

    public SQLStore(Class<T> klass, Context context, GsonBuilder builder, IdGenerator generator, String databaseName) {
        super(context, databaseName, null, 1);
        this.klass = klass;
        this.className = databaseName;
        this.gson = builder.create();
        this.generator = generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> readAll() {
        this.ensureOpen();
        String sql = String.format("Select PROPERTY_NAME, PROPERTY_VALUE,PARENT_ID from %s_property", this.className);
        Cursor cursor = this.database.rawQuery(sql, new String[0]);
        HashMap<String, JsonObject> objects = new HashMap<String, JsonObject>(cursor.getCount());
        try {
            while (cursor.moveToNext()) {
                String id = cursor.getString(2);
                JsonObject object = (JsonObject)objects.get(id);
                if (object == null) {
                    object = new JsonObject();
                    objects.put(id, object);
                }
                this.add(object, cursor.getString(0), cursor.getString(1));
            }
        }
        finally {
            cursor.close();
        }
        ArrayList<Object> data = new ArrayList<Object>(cursor.getCount());
        for (JsonObject object : objects.values()) {
            data.add(this.gson.fromJson((JsonElement)object, this.klass));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Serializable id) {
        this.ensureOpen();
        String sql = String.format("Select PROPERTY_NAME, PROPERTY_VALUE from %s_property where PARENT_ID = ?", this.className);
        String[] bindArgs = new String[]{id.toString()};
        JsonObject result = new JsonObject();
        Cursor cursor = this.database.rawQuery(sql, bindArgs);
        if (cursor.getCount() == 0) {
            return null;
        }
        try {
            while (cursor.moveToNext()) {
                this.add(result, cursor.getString(0), cursor.getString(1));
            }
        }
        finally {
            cursor.close();
        }
        return (T)this.gson.fromJson((JsonElement)result, this.klass);
    }

    @Override
    public List<T> readWithFilter(ReadFilter filter) {
        this.ensureOpen();
        if (filter == null) {
            filter = new ReadFilter();
        }
        String sql = String.format("select PARENT_ID from %s_property where PROPERTY_NAME LIKE ? and PROPERTY_VALUE = ?", this.className);
        JsonObject where = (JsonObject)new JsonParser().parse(filter.getWhere().toString());
        ArrayList<Pair<String, String>> queryList = new ArrayList<Pair<String, String>>();
        HashMap<String, AtomicInteger> resultCount = new HashMap<String, AtomicInteger>();
        this.buildKeyValuePairs(where, queryList, "");
        if (queryList.isEmpty()) {
            return new ArrayList<T>(this.readAll());
        }
        for (Pair pair : queryList) {
            String[] bindArgs = new String[]{(String)pair.first, (String)pair.second};
            Cursor cursor = this.database.rawQuery(sql, bindArgs);
            while (cursor.moveToNext()) {
                String id = cursor.getString(0);
                AtomicInteger count = (AtomicInteger)resultCount.get(id);
                if (count == null) {
                    count = new AtomicInteger(0);
                    resultCount.put(id, count);
                }
                count.incrementAndGet();
            }
            cursor.close();
        }
        ArrayList<T> results = new ArrayList<T>();
        for (String id : resultCount.keySet()) {
            if (((AtomicInteger)resultCount.get(id)).get() != queryList.size()) continue;
            results.add(this.read((Serializable)((Object)id)));
        }
        return results;
    }

    @Override
    public void save(T item) {
        this.ensureOpen();
        this.database.beginTransaction();
        try {
            this.saveItem(item);
            this.database.setTransactionSuccessful();
        }
        finally {
            this.database.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Collection<T> items) {
        this.ensureOpen();
        this.database.beginTransaction();
        try {
            for (T item : items) {
                this.saveItem(item);
            }
            this.database.setTransactionSuccessful();
        }
        finally {
            this.database.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveItem(T item) {
        String recordIdFieldName = Scan.recordIdFieldNameIn(item.getClass());
        Property property = new Property(item.getClass(), recordIdFieldName);
        Serializable idValue = (Serializable)property.getValue(item);
        if (idValue == null) {
            idValue = this.generator.generate();
            property.setValue(item, (Object)idValue);
        }
        JsonObject serialized = (JsonObject)this.gson.toJsonTree(item, this.klass);
        this.database.beginTransaction();
        try {
            this.saveElement((JsonElement)serialized, "", idValue);
            this.database.setTransactionSuccessful();
        }
        finally {
            this.database.endTransaction();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveElement(JsonElement serialized, String path, Serializable id) {
        String sql = String.format("insert into %s_property (PROPERTY_NAME, PROPERTY_VALUE, PARENT_ID) values (?,?,?)", this.className);
        if (serialized.isJsonObject()) {
            Set members = ((JsonObject)serialized).entrySet();
            String pathVar = path.isEmpty() ? "" : ".";
            for (Map.Entry member : members) {
                JsonElement jsonValue = (JsonElement)member.getValue();
                String propertyName = (String)member.getKey();
                if (jsonValue.isJsonArray()) {
                    JsonArray jsonArray = jsonValue.getAsJsonArray();
                    for (int index = 0; index < jsonArray.size(); ++index) {
                        this.saveElement(jsonArray.get(index), path + pathVar + propertyName + String.format("[%d]", index), id);
                    }
                    continue;
                }
                this.saveElement(jsonValue, path + pathVar + propertyName, id);
            }
            return;
        }
        if (!serialized.isJsonPrimitive()) throw new IllegalArgumentException(serialized + " isn't a JsonObject or JsonPrimitive");
        JsonPrimitive primitive = serialized.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            String value = primitive.getAsBoolean() ? "true" : "false";
            this.database.execSQL(sql, new Object[]{path, value, id});
            return;
        } else if (primitive.isNumber()) {
            Number value = primitive.getAsNumber();
            this.database.execSQL(sql, new Object[]{path, value, id});
            return;
        } else {
            if (!primitive.isString()) throw new IllegalArgumentException(serialized + " isn't a number, boolean, or string");
            String value = primitive.getAsString();
            this.database.execSQL(sql, new Object[]{path, value, id});
        }
    }

    @Override
    public void reset() {
        this.ensureOpen();
        String sql = String.format("Delete from %s_property", this.className);
        this.database.execSQL(sql);
    }

    @Override
    public boolean isEmpty() {
        this.ensureOpen();
        String sql = String.format("Select count(_ID) from %s_property", this.className);
        Cursor cursor = this.database.rawQuery(sql, null);
        cursor.moveToFirst();
        boolean result = cursor.getInt(0) == 0;
        cursor.close();
        return result;
    }

    @Override
    public void remove(Serializable id) {
        this.ensureOpen();
        String sql = String.format("Delete from %s_property where PARENT_ID = ?", this.className);
        Object[] bindArgs = new Object[]{id};
        this.database.execSQL(sql, bindArgs);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(String.format(CREATE_PROPERTIES_TABLE, this.className));
        db.execSQL(String.format(CREATE_PROPERTIES_INDEXES, this.className, this.className, this.className, this.className, this.className, this.className));
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public void open(final Callback<SQLStore<T>> onReady) {
        new AsyncTask<Void, Void, Void>(){
            private Exception exception;

            protected Void doInBackground(Void ... params) {
                try {
                    SQLStore.this.database = SQLStore.this.getWritableDatabase();
                }
                catch (Exception e) {
                    this.exception = e;
                    Log.e((String)TAG, (String)"There was an error loading the database", (Throwable)e);
                }
                return null;
            }

            protected void onPostExecute(Void result) {
                if (this.exception != null) {
                    onReady.onFailure(this.exception);
                } else {
                    onReady.onSuccess((Object)SQLStore.this);
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])null);
    }

    public void openSync() {
        this.database = this.getWritableDatabase();
    }

    public void close() {
        this.database.close();
    }

    private void add(JsonObject result, String propertyName, String propertyValue) {
        if (!propertyName.contains(".")) {
            if (propertyName.contains("[")) {
                String unArrayPropertyName = propertyName.split("\\[")[0];
                if (!result.has(unArrayPropertyName)) {
                    result.add(unArrayPropertyName, (JsonElement)new JsonArray());
                }
                JsonArray array = result.getAsJsonArray(unArrayPropertyName);
                array.add(this.gson.toJsonTree((Object)propertyValue));
            } else {
                result.addProperty(propertyName, propertyValue);
            }
        } else {
            String[] names = propertyName.split("\\.", 2);
            if (names[0].contains("[")) {
                String key = names[0].split("\\[")[0];
                Integer index = Integer.parseInt(names[0].split("\\[")[1].split("\\]")[0]);
                JsonArray subObject = result.getAsJsonArray(key);
                if (subObject == null) {
                    subObject = new JsonArray();
                    result.add(key, (JsonElement)subObject);
                }
                if (index >= subObject.size()) {
                    for (int i = subObject.size(); i < index + 1; ++i) {
                        subObject.add((JsonElement)new JsonObject());
                    }
                }
                JsonObject arrayItem = subObject.get(index.intValue()).getAsJsonObject();
                this.add(arrayItem, names[1], propertyValue);
            } else {
                JsonObject subObject = (JsonObject)result.get(names[0]);
                if (subObject == null) {
                    subObject = new JsonObject();
                    result.add(names[0], (JsonElement)subObject);
                }
                this.add(subObject, names[1], propertyValue);
            }
        }
    }

    private void buildKeyValuePairs(JsonObject where, List<Pair<String, String>> keyValues, String parentPath) {
        Set keys = where.entrySet();
        String pathVar = parentPath.isEmpty() ? "" : ".";
        for (Map.Entry entry : keys) {
            String key = (String)entry.getKey();
            String path = parentPath + pathVar + key;
            JsonElement jsonValue = (JsonElement)entry.getValue();
            if (jsonValue.isJsonObject()) {
                this.buildKeyValuePairs((JsonObject)jsonValue, keyValues, path);
                continue;
            }
            if (jsonValue.isJsonPrimitive()) {
                Object value;
                JsonPrimitive primitive = jsonValue.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    value = primitive.getAsBoolean() ? "true" : "false";
                    keyValues.add((Pair<String, String>)new Pair((Object)path, value));
                    continue;
                }
                if (primitive.isNumber()) {
                    value = primitive.getAsNumber();
                    keyValues.add((Pair<String, String>)new Pair((Object)path, (Object)value.toString()));
                    continue;
                }
                if (primitive.isString()) {
                    value = primitive.getAsString();
                    keyValues.add((Pair<String, String>)new Pair((Object)path, value));
                    continue;
                }
                throw new IllegalArgumentException(jsonValue + " isn't a number, boolean, or string");
            }
            throw new IllegalArgumentException(jsonValue + " isn't a JsonPrimitive");
        }
    }

    private boolean isOpen() {
        return this.database != null;
    }

    private void ensureOpen() {
        if (!this.isOpen()) {
            Log.w((String)TAG, (String)"Store is not opened, trying to open.");
            this.openSync();
        }
    }
}

