/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.store.memory;

import android.content.Context;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.android.core.ReadFilter;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.InvalidKeyException;
import org.jboss.aerogear.android.security.SecurityManager;
import org.jboss.aerogear.android.security.keystore.KeyStoreBasedEncryptionConfiguration;
import org.jboss.aerogear.android.store.Store;
import org.jboss.aerogear.android.store.generator.IdGenerator;
import org.jboss.aerogear.android.store.memory.MemoryStore;
import org.jboss.aerogear.android.store.util.CryptoEntityUtil;
import org.jboss.aerogear.crypto.RandomUtils;

public class EncryptedMemoryStore<T>
implements Store<T> {
    private final MemoryStore<byte[]> memoryStore;
    private final CryptoEntityUtil<T> cryptoEntityUtil;

    public EncryptedMemoryStore(Context context, IdGenerator idGenerator, String password, Class<T> modelClass) {
        this.memoryStore = new MemoryStore(idGenerator);
        byte[] iv = RandomUtils.randomBytes();
        EncryptionService encryptionService = ((KeyStoreBasedEncryptionConfiguration)((KeyStoreBasedEncryptionConfiguration)SecurityManager.config((String)modelClass.getName(), KeyStoreBasedEncryptionConfiguration.class)).setContext(context)).setAlias(modelClass.getName()).setKeyStoreFile(modelClass.getName()).setPassword(password).asService();
        this.cryptoEntityUtil = new CryptoEntityUtil<T>(encryptionService, iv, modelClass);
    }

    @Override
    public Collection<T> readAll() throws InvalidKeyException {
        ArrayList<T> dataList = new ArrayList<T>();
        Collection<byte[]> encryptedCollection = this.memoryStore.readAll();
        for (byte[] encryptedData : encryptedCollection) {
            T decryptedData = this.cryptoEntityUtil.decrypt(encryptedData);
            dataList.add(decryptedData);
        }
        return dataList;
    }

    @Override
    public T read(Serializable id) throws InvalidKeyException {
        byte[] encryptedItem = this.memoryStore.read(id);
        if (encryptedItem == null) {
            return null;
        }
        return this.cryptoEntityUtil.decrypt(encryptedItem);
    }

    @Override
    public List<T> readWithFilter(ReadFilter filter) throws InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(T item) {
        Serializable idValue = this.memoryStore.getOrGenerateIdValue(item);
        this.memoryStore.save(idValue, this.cryptoEntityUtil.encrypt(item));
    }

    @Override
    public void save(Collection<T> items) {
        for (T item : items) {
            this.save(item);
        }
    }

    @Override
    public void reset() {
        this.memoryStore.reset();
    }

    @Override
    public void remove(Serializable id) {
        this.memoryStore.remove(id);
    }

    @Override
    public boolean isEmpty() {
        return this.memoryStore.isEmpty();
    }
}

