/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AbstractAuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.authentication.impl.AGSecurityAuthenticationConfig;
import org.jboss.aerogear.android.authentication.impl.AGSecurityAuthenticationModuleRunner;
import org.jboss.aerogear.android.http.HeaderAndBody;

public final class AGSecurityAuthenticationModule
extends AbstractAuthenticationModule {
    private static final String TAG = AGSecurityAuthenticationModule.class.getSimpleName();
    private String authToken = "";
    private final String tokenHeaderName;
    private boolean isLoggedIn = false;
    private final AGSecurityAuthenticationModuleRunner runner;

    public AGSecurityAuthenticationModule(URL baseURL, AuthenticationConfig config) {
        this.runner = new AGSecurityAuthenticationModuleRunner(baseURL, config);
        this.tokenHeaderName = config instanceof AGSecurityAuthenticationConfig ? ((AGSecurityAuthenticationConfig)config).getTokenHeaderName() : "Auth-Token";
    }

    @Override
    public URL getBaseURL() {
        return this.runner.getBaseURL();
    }

    @Override
    public String getLoginEndpoint() {
        return this.runner.getLoginEndpoint();
    }

    @Override
    public String getLogoutEndpoint() {
        return this.runner.getLogoutEndpoint();
    }

    @Override
    public String getEnrollEndpoint() {
        return this.runner.getEnrollEndpoint();
    }

    @Override
    public void enroll(final Map<String, String> userData, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = AGSecurityAuthenticationModule.this.runner.onEnroll(userData);
                    AGSecurityAuthenticationModule.this.authToken = result.getHeader(AGSecurityAuthenticationModule.this.tokenHeaderName).toString();
                    AGSecurityAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"error enrolling", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void login(final String username, final String password, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = AGSecurityAuthenticationModule.this.runner.onLogin(username, password);
                    AGSecurityAuthenticationModule.this.authToken = result.getHeader(AGSecurityAuthenticationModule.this.tokenHeaderName).toString();
                    AGSecurityAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void logout(final Callback<Void> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    AGSecurityAuthenticationModule.this.runner.onLogout();
                    AGSecurityAuthenticationModule.this.authToken = "";
                    AGSecurityAuthenticationModule.this.isLoggedIn = false;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    protected String getAuthToken() {
        return this.authToken;
    }

    @Override
    public AuthorizationFields getAuthorizationFields() {
        AuthorizationFields fields = new AuthorizationFields();
        fields.addHeader(this.tokenHeaderName, this.authToken);
        return fields;
    }
}

