/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl.loader.support;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.authentication.impl.loader.LoaderAuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.loader.support.AbstractSupportAuthenticationLoader;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportEnrollLoader;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportLoginLoader;
import org.jboss.aerogear.android.authentication.impl.loader.support.SupportLogoutLoader;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.pipeline.support.AbstractFragmentActivityCallback;
import org.jboss.aerogear.android.pipeline.support.AbstractSupportFragmentCallback;

public class SupportAuthenticationModuleAdapter
implements LoaderAuthenticationModule,
LoaderManager.LoaderCallbacks<HeaderAndBody> {
    private static final String TAG = SupportAuthenticationModuleAdapter.class.getSimpleName();
    private final Context applicationContext;
    private final AuthenticationModule module;
    private final LoaderManager manager;
    private final FragmentActivity activity;
    private final Fragment fragment;
    private final Handler handler;
    private final String name;

    public SupportAuthenticationModuleAdapter(FragmentActivity activity, AuthenticationModule module, String name) {
        this.module = module;
        this.manager = activity.getSupportLoaderManager();
        this.applicationContext = activity.getApplicationContext();
        this.fragment = null;
        this.activity = activity;
        this.handler = new Handler(Looper.getMainLooper());
        this.name = name;
    }

    public SupportAuthenticationModuleAdapter(Fragment fragment, Context applicationContext, AuthenticationModule module, String name) {
        this.module = module;
        this.manager = fragment.getLoaderManager();
        this.applicationContext = applicationContext;
        this.fragment = fragment;
        this.activity = null;
        this.handler = new Handler(Looper.getMainLooper());
        this.name = name;
    }

    @Override
    public URL getBaseURL() {
        return this.module.getBaseURL();
    }

    @Override
    public String getLoginEndpoint() {
        return this.module.getLoginEndpoint();
    }

    @Override
    public String getLogoutEndpoint() {
        return this.module.getLogoutEndpoint();
    }

    @Override
    public String getEnrollEndpoint() {
        return this.module.getEnrollEndpoint();
    }

    @Override
    public void enroll(Map<String, String> userData, Callback<HeaderAndBody> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, userData, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS", new HashMap<String, String>(userData));
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)((Object)Methods.ENROLL));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void login(String username, String password, Callback<HeaderAndBody> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, username, password, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME", (Serializable)((Object)username));
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD", (Serializable)((Object)password));
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)((Object)Methods.LOGIN));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void logout(Callback<Void> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD", (Serializable)((Object)Methods.LOGOUT));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public boolean isLoggedIn() {
        return this.module.isLoggedIn();
    }

    @Override
    public AuthorizationFields getAuthorizationFields() {
        return this.module.getAuthorizationFields();
    }

    public Loader<HeaderAndBody> onCreateLoader(int id, Bundle bundle) {
        Methods method = (Methods)((Object)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.METHOD"));
        Callback callback = (Callback)bundle.get("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.CALLBACK");
        AbstractSupportAuthenticationLoader loader = null;
        switch (method) {
            case LOGIN: {
                String username = bundle.getString("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.USERNAME");
                String password = bundle.getString("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PASSWORD");
                loader = new SupportLoginLoader(this.applicationContext, callback, this.module, username, password);
                break;
            }
            case LOGOUT: {
                loader = new SupportLogoutLoader(this.applicationContext, callback, this.module);
                break;
            }
            case ENROLL: {
                Map params = (Map)((Object)bundle.getSerializable("org.jboss.aerogear.android.authentication.loader.AuthenticationModuleAdapter.PARAMS"));
                loader = new SupportEnrollLoader(this.applicationContext, callback, this.module, params);
            }
        }
        return loader;
    }

    public void onLoadFinished(Loader<HeaderAndBody> loader, HeaderAndBody data) {
        if (!(loader instanceof AbstractSupportAuthenticationLoader)) {
            Log.e((String)TAG, (String)"Adapter is listening to loaders which it doesn't support");
            throw new IllegalStateException("Adapter is listening to loaders which it doesn't support");
        }
        AbstractSupportAuthenticationLoader supportLoader = (AbstractSupportAuthenticationLoader)loader;
        this.handler.post((Runnable)new CallbackHandler(this, supportLoader, data));
    }

    public void onLoaderReset(Loader<HeaderAndBody> loader) {
    }

    private void fragmentSuccess(Callback<HeaderAndBody> typelessCallback, HeaderAndBody data) {
        AbstractSupportFragmentCallback callback = (AbstractSupportFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onSuccess(data);
        callback.setFragment(null);
    }

    private void fragmentFailure(Callback<HeaderAndBody> typelessCallback, Exception exception) {
        AbstractSupportFragmentCallback callback = (AbstractSupportFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onFailure(exception);
        callback.setFragment(null);
    }

    private void activitySuccess(Callback<HeaderAndBody> typelessCallback, HeaderAndBody data) {
        AbstractFragmentActivityCallback callback = (AbstractFragmentActivityCallback)typelessCallback;
        callback.setFragmentActivity(this.activity);
        callback.onSuccess(data);
        callback.setFragmentActivity(null);
    }

    private void activityFailure(Callback<HeaderAndBody> typelessCallback, Exception exception) {
        AbstractFragmentActivityCallback callback = (AbstractFragmentActivityCallback)typelessCallback;
        callback.setFragmentActivity(this.activity);
        callback.onFailure(exception);
        callback.setFragmentActivity(null);
    }

    static final class CallbackHandler
    implements Runnable {
        private final SupportAuthenticationModuleAdapter adapter;
        private final AbstractSupportAuthenticationLoader supportLoader;
        private final HeaderAndBody data;

        public CallbackHandler(SupportAuthenticationModuleAdapter adapter, AbstractSupportAuthenticationLoader loader, HeaderAndBody data) {
            this.adapter = adapter;
            this.supportLoader = loader;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.supportLoader.hasException()) {
                Exception exception = this.supportLoader.getException();
                Log.e((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                if (this.supportLoader.getCallback() instanceof AbstractSupportFragmentCallback) {
                    this.adapter.fragmentFailure(this.supportLoader.getCallback(), exception);
                } else if (this.supportLoader.getCallback() instanceof AbstractFragmentActivityCallback) {
                    this.adapter.activityFailure(this.supportLoader.getCallback(), exception);
                } else {
                    this.supportLoader.getCallback().onFailure(exception);
                }
            } else if (this.supportLoader.getCallback() instanceof AbstractSupportFragmentCallback) {
                this.adapter.fragmentSuccess(this.supportLoader.getCallback(), this.data);
            } else if (this.supportLoader.getCallback() instanceof AbstractFragmentActivityCallback) {
                this.adapter.activitySuccess(this.supportLoader.getCallback(), this.data);
            } else {
                this.supportLoader.getCallback().onSuccess(this.data);
            }
        }
    }

    static enum Methods {
        LOGIN,
        LOGOUT,
        ENROLL;

    }
}

