/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.app.Activity;
import android.app.Fragment;
import android.app.LoaderManager;
import android.content.Context;
import android.content.Loader;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.common.base.Objects;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.impl.pipeline.loader.AbstractPipeLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.ReadLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.RemoveLoader;
import org.jboss.aerogear.android.impl.pipeline.loader.SaveLoader;
import org.jboss.aerogear.android.pipeline.AbstractActivityCallback;
import org.jboss.aerogear.android.pipeline.AbstractFragmentCallback;
import org.jboss.aerogear.android.pipeline.LoaderPipe;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.PipeType;

public class LoaderAdapter<T>
implements LoaderPipe<T>,
LoaderManager.LoaderCallbacks<T> {
    private static final String TAG = LoaderAdapter.class.getSimpleName();
    private final Handler handler;
    private Multimap<String, Integer> idsForNamedPipes;
    private final Context applicationContext;
    private Fragment fragment;
    private Activity activity;
    private final Pipe<T> pipe;
    private final LoaderManager manager;
    private final Gson gson;
    private final String name;

    public LoaderAdapter(Activity activity, Pipe<T> pipe, Gson gson, String name) {
        this.pipe = pipe;
        this.gson = gson;
        this.manager = activity.getLoaderManager();
        this.applicationContext = activity.getApplicationContext();
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.activity = activity;
    }

    public LoaderAdapter(Fragment fragment, Context applicationContext, Pipe<T> pipe, Gson gson, String name) {
        this.pipe = pipe;
        this.manager = fragment.getLoaderManager();
        this.gson = gson;
        this.applicationContext = applicationContext;
        this.name = name;
        this.handler = new Handler(Looper.getMainLooper());
        this.fragment = fragment;
    }

    @Override
    public PipeType getType() {
        return this.pipe.getType();
    }

    @Override
    public URL getUrl() {
        return this.pipe.getUrl();
    }

    @Override
    public void read(Callback<List<T>> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", null);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void readWithFilter(ReadFilter filter, Callback<List<T>> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, filter, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER", (Serializable)filter);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.READ));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void save(T item, Callback<T> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, item, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM", (Serializable)((Object)this.gson.toJson(item)));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.SAVE));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public void remove(String toRemoveId, Callback<Void> callback) {
        int id = Objects.hashCode((Object[])new Object[]{this.name, toRemoveId, callback});
        Bundle bundle = new Bundle();
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK", callback);
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID", (Serializable)((Object)toRemoveId));
        bundle.putSerializable("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD", (Serializable)((Object)Methods.REMOVE));
        this.manager.initLoader(id, bundle, (LoaderManager.LoaderCallbacks)this);
    }

    @Override
    public PipeHandler<T> getHandler() {
        return this.pipe.getHandler();
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public Class<T> getKlass() {
        return this.pipe.getKlass();
    }

    public Loader<T> onCreateLoader(int id, Bundle bundle) {
        this.idsForNamedPipes.put((Object)this.name, (Object)id);
        Methods method = (Methods)((Object)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.METHOD"));
        Callback callback = (Callback)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.CALLBACK");
        AbstractPipeLoader loader = null;
        switch (method) {
            case READ: {
                ReadFilter filter = (ReadFilter)bundle.get("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.FILTER");
                loader = new ReadLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), filter, this);
                break;
            }
            case REMOVE: {
                String toRemove = bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.REMOVIE_ID", "-1");
                loader = new RemoveLoader<T>(this.applicationContext, callback, this.pipe.getHandler(), toRemove);
                break;
            }
            case SAVE: {
                String json = bundle.getString("org.jboss.aerogear.android.impl.pipeline.LoaderPipe.ITEM");
                Object item = this.gson.fromJson(json, this.pipe.getKlass());
                loader = new SaveLoader<Object>(this.applicationContext, callback, this.pipe.getHandler(), item);
            }
        }
        return loader;
    }

    public void onLoadFinished(Loader<T> loader, T data) {
        if (!(loader instanceof AbstractPipeLoader)) {
            Log.e((String)TAG, (String)"Adapter is listening to loaders which it doesn't support");
            throw new IllegalStateException("Adapter is listening to loaders which it doesn't support");
        }
        AbstractPipeLoader modernLoader = (AbstractPipeLoader)loader;
        this.handler.post(new CallbackHandler<T>(this, modernLoader, data));
    }

    public void onLoaderReset(Loader<T> loader) {
        Log.e((String)TAG, (String)loader.toString());
    }

    @Override
    public void reset() {
        for (Integer id : this.idsForNamedPipes.get((Object)this.name)) {
            Loader loader = this.manager.getLoader(id.intValue());
            if (loader == null) continue;
            this.manager.destroyLoader(id.intValue());
        }
        this.idsForNamedPipes.removeAll((Object)this.name);
    }

    @Override
    public void setLoaderIds(Multimap<String, Integer> idsForNamedPipes) {
        this.idsForNamedPipes = idsForNamedPipes;
    }

    private void fragmentSuccess(Callback<T> typelessCallback, T data) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onSuccess(data);
        callback.setFragment(null);
    }

    private void fragmentFailure(Callback<T> typelessCallback, Exception exception) {
        AbstractFragmentCallback callback = (AbstractFragmentCallback)typelessCallback;
        callback.setFragment(this.fragment);
        callback.onFailure(exception);
        callback.setFragment(null);
    }

    private void activitySuccess(Callback<T> typelessCallback, T data) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onSuccess(data);
        callback.setActivity(null);
    }

    private void activityFailure(Callback<T> typelessCallback, Exception exception) {
        AbstractActivityCallback callback = (AbstractActivityCallback)typelessCallback;
        callback.setActivity(this.activity);
        callback.onFailure(exception);
        callback.setActivity(null);
    }

    static class CallbackHandler<T>
    implements Runnable {
        private final LoaderAdapter<T> adapter;
        private final AbstractPipeLoader<T> modernLoader;
        private final T data;

        public CallbackHandler(LoaderAdapter<T> adapter, AbstractPipeLoader<T> loader, T data) {
            this.adapter = adapter;
            this.modernLoader = loader;
            this.data = data;
        }

        @Override
        public void run() {
            if (this.modernLoader.hasException()) {
                Exception exception = this.modernLoader.getException();
                Log.e((String)TAG, (String)exception.getMessage(), (Throwable)exception);
                if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                    ((LoaderAdapter)this.adapter).fragmentFailure(this.modernLoader.getCallback(), exception);
                } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                    ((LoaderAdapter)this.adapter).activityFailure(this.modernLoader.getCallback(), exception);
                } else {
                    this.modernLoader.getCallback().onFailure(exception);
                }
            } else if (this.modernLoader.getCallback() instanceof AbstractFragmentCallback) {
                ((LoaderAdapter)this.adapter).fragmentSuccess(this.modernLoader.getCallback(), this.data);
            } else if (this.modernLoader.getCallback() instanceof AbstractActivityCallback) {
                ((LoaderAdapter)this.adapter).activitySuccess(this.modernLoader.getCallback(), this.data);
            } else {
                this.modernLoader.getCallback().onSuccess(this.data);
            }
        }
    }

    private static enum Methods {
        READ,
        SAVE,
        REMOVE;

    }
}

