/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.util;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.jboss.aerogear.android.impl.pipeline.paging.WebLink;
import org.jboss.aerogear.android.impl.util.ParseException;

public class WebLinkParser {
    private static final String TAG = WebLinkParser.class.getSimpleName();
    private static final Character COMMA = Character.valueOf(',');
    private static final Character QUOTE = Character.valueOf('\"');
    private static final Character OPEN_LINK = Character.valueOf('<');
    private static final Character CLOSE_LINK = Character.valueOf('>');

    public static List<WebLink> parse(String linkHeader) throws ParseException {
        if (linkHeader == null) {
            throw new IllegalArgumentException("null String passed to WebLinkParser.parse");
        }
        ArrayList<WebLink> linksList = new ArrayList<WebLink>();
        boolean inBrackets = false;
        boolean inQuotes = false;
        char[] linkHeaderCharacters = linkHeader.trim().toCharArray();
        StringBuilder buffer = new StringBuilder(linkHeader.length());
        char[] arr$ = linkHeaderCharacters;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (inBrackets) {
                inBrackets = !c.equals(CLOSE_LINK);
                WebLinkParser.appendPrintedCharacter(buffer, c);
                continue;
            }
            if (inQuotes) {
                inQuotes = !c.equals(QUOTE);
                WebLinkParser.appendPrintedCharacter(buffer, c);
                continue;
            }
            inBrackets = c.equals(OPEN_LINK);
            inQuotes = c.equals(QUOTE);
            if (c.equals(COMMA)) {
                String link = buffer.toString();
                buffer.delete(0, buffer.length());
                try {
                    linksList.add(new WebLink(link));
                    continue;
                }
                catch (ParseException parseEx) {
                    Log.e((String)TAG, (String)"Parse error", (Throwable)parseEx);
                    throw parseEx;
                }
            }
            WebLinkParser.appendPrintedCharacter(buffer, c);
        }
        if (buffer.toString().trim().length() > 0) {
            try {
                linksList.add(new WebLink(buffer.toString()));
            }
            catch (ParseException parseEx) {
                Log.e((String)TAG, (String)"Parse error", (Throwable)parseEx);
                throw parseEx;
            }
        }
        return linksList;
    }

    private static void appendPrintedCharacter(StringBuilder buffer, Character c) {
        if (!Character.isWhitespace(c.charValue())) {
            buffer.append(c);
        }
    }
}

