/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import com.google.gson.JsonObject;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.core.HttpProviderFactory;
import org.jboss.aerogear.android.impl.util.UrlUtils;
import org.json.JSONObject;

class AGSecurityAuthenticationModuleRunner {
    private static final String TAG = AGSecurityAuthenticationModuleRunner.class.getSimpleName();
    private final Provider<HttpProvider> httpProviderFactory = new HttpProviderFactory();
    private final URL baseURL;
    private final String loginEndpoint;
    private final URL loginURL;
    private final String logoutEndpoint;
    private final URL logoutURL;
    private final String enrollEndpoint;
    private final URL enrollURL;
    private final Integer timeout;

    public AGSecurityAuthenticationModuleRunner(URL baseURL, AuthenticationConfig config) {
        this.baseURL = baseURL;
        this.loginEndpoint = config.getLoginEndpoint();
        this.logoutEndpoint = config.getLogoutEndpoint();
        this.enrollEndpoint = config.getEnrollEndpoint();
        this.loginURL = UrlUtils.appendToBaseURL(baseURL, this.loginEndpoint);
        this.logoutURL = UrlUtils.appendToBaseURL(baseURL, this.logoutEndpoint);
        this.enrollURL = UrlUtils.appendToBaseURL(baseURL, this.enrollEndpoint);
        this.timeout = config.getTimeout();
    }

    public HeaderAndBody onEnroll(Map<String, String> userData) {
        HttpProvider provider = this.httpProviderFactory.get(this.enrollURL, this.timeout);
        String enrollData = new JSONObject(userData).toString();
        return provider.post(enrollData);
    }

    public HeaderAndBody onLogin(String username, String password) {
        HttpProvider provider = this.httpProviderFactory.get(this.loginURL, this.timeout);
        String loginData = this.buildLoginData(username, password);
        return provider.post(loginData);
    }

    public void onLogout() {
        HttpProvider provider = this.httpProviderFactory.get(this.logoutURL, this.timeout);
        provider.post("");
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public String getLoginEndpoint() {
        return this.loginEndpoint;
    }

    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public String getEnrollEndpoint() {
        return this.enrollEndpoint;
    }

    private String buildLoginData(String username, String password) {
        JsonObject response = new JsonObject();
        response.addProperty("username", username);
        response.addProperty("password", password);
        return response.toString();
    }
}

