/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.datamanager.StoreType;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;
import org.jboss.aerogear.android.impl.reflection.Property;
import org.jboss.aerogear.android.impl.reflection.Scan;
import org.json.JSONObject;

public class MemoryStorage<T>
implements Store<T> {
    private final Map<Serializable, T> data = new HashMap<Serializable, T>();
    private final IdGenerator idGenerator;

    public MemoryStorage(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public StoreType getType() {
        return StoreTypes.MEMORY;
    }

    @Override
    public Collection<T> readAll() {
        return this.data.values();
    }

    @Override
    public T read(Serializable id) {
        return this.data.get(id);
    }

    @Override
    public void save(T item) {
        String recordIdFieldName = Scan.recordIdFieldNameIn(item.getClass());
        Property property = new Property(item.getClass(), recordIdFieldName);
        Serializable idValue = (Serializable)property.getValue(item);
        if (idValue == null) {
            idValue = this.idGenerator.generate();
            property.setValue(item, idValue);
        }
        this.data.put(idValue, item);
    }

    @Override
    public void reset() {
        this.data.clear();
    }

    @Override
    public void remove(Serializable id) {
        this.data.remove(id);
    }

    @Override
    public List<T> readWithFilter(ReadFilter filter) {
        if (filter == null) {
            filter = new ReadFilter();
        }
        JSONObject where = filter.getWhere();
        this.scanForNestedObjectsInWhereClause(where);
        List<T> results = new ArrayList<T>(this.data.values());
        this.filterData(results, where);
        results = this.pageData(results, filter.getLimit(), filter.getOffset());
        return results;
    }

    private void scanForNestedObjectsInWhereClause(JSONObject where) {
        Iterator keys = where.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            Object value = where.opt(key);
            if (!(value instanceof JSONObject)) continue;
            throw new IllegalArgumentException("readWithFilter does not support nested objects");
        }
    }

    private void filterData(Collection<T> data, JSONObject where) {
        Iterator keys = where.keys();
        while (keys.hasNext()) {
            ArrayList<T> toRemove = new ArrayList<T>(data.size());
            String filterPropertyName = keys.next().toString();
            Object filterValue = where.opt(filterPropertyName);
            for (T objectInStorage : data) {
                Property objectProperty = new Property(objectInStorage.getClass(), filterPropertyName);
                Object propertyValue = objectProperty.getValue(objectInStorage);
                if (propertyValue == null || filterValue == null || propertyValue.equals(filterValue)) continue;
                toRemove.add(objectInStorage);
            }
            data.removeAll(toRemove);
        }
    }

    private List<T> pageData(List<T> results, Integer limit, Integer offset) {
        return results.subList(offset, Math.min(offset + limit, results.size()));
    }
}

