/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import com.google.gson.GsonBuilder;
import java.net.URL;
import java.nio.charset.Charset;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.impl.pipeline.PipeTypes;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.PipeType;
import org.jboss.aerogear.android.pipeline.paging.PageConfig;

public final class PipeConfig {
    private URL baseURL;
    private String name;
    private String endpoint;
    private PipeType type = PipeTypes.REST;
    private PageConfig pageConfig;
    private GsonBuilder gsonBuilder;
    private AuthenticationModule authModule;
    private PipeHandler handler;
    private Integer timeout = Integer.MAX_VALUE;
    private String dataRoot = "";
    private Charset encoding = Charset.forName("UTF-8");

    public PipeConfig(URL baseURL, Class klass) {
        this.baseURL = baseURL;
        this.endpoint = this.name = klass.getSimpleName().toLowerCase();
        this.type = PipeTypes.REST;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public PipeType getType() {
        return this.type;
    }

    public void setType(PipeType type) {
        this.type = type;
    }

    public GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    public void setGsonBuilder(GsonBuilder gsonBuilder) {
        this.gsonBuilder = gsonBuilder;
    }

    public AuthenticationModule getAuthModule() {
        return this.authModule;
    }

    public void setAuthModule(AuthenticationModule authModule) {
        this.authModule = authModule;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding may not be null");
        }
        this.encoding = encoding;
    }

    public void setEncoding(String charsetName) {
        this.encoding = Charset.forName(charsetName);
    }

    public PageConfig getPageConfig() {
        return this.pageConfig;
    }

    public void setPageConfig(PageConfig pageConfig) {
        this.pageConfig = pageConfig;
    }

    public String getDataRoot() {
        return this.dataRoot;
    }

    public void setDataRoot(String dataRoot) {
        this.dataRoot = dataRoot;
    }

    public PipeHandler getHandler() {
        return this.handler;
    }

    public void setHandler(PipeHandler handler) {
        this.handler = handler;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }
}

