/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Base64;
import android.util.Pair;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AbstractAuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.http.HeaderAndBody;

public class HttpBasicAuthenticationModule
extends AbstractAuthenticationModule {
    private static final String BASIC_HEADER = "Authorization";
    private static final String AUTHORIZATION_METHOD = "Basic";
    private final String loginEndpoint = "";
    private final String logoutEndpoint = "";
    private final String enrollEndpoint = "";
    private final URL baseURL;
    private boolean isLoggedIn = false;
    private PasswordAuthentication auth = new PasswordAuthentication("", new char[0]);

    public HttpBasicAuthenticationModule(URL baseURL) {
        this.baseURL = baseURL;
    }

    @Override
    public URL getBaseURL() {
        return this.baseURL;
    }

    @Override
    public String getLoginEndpoint() {
        return "";
    }

    @Override
    public String getLogoutEndpoint() {
        return "";
    }

    @Override
    public String getEnrollEndpoint() {
        return "";
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    @Override
    public void login(String username, String password, final Callback<HeaderAndBody> callback) {
        this.isLoggedIn = true;
        this.auth = new PasswordAuthentication(username, password.toCharArray());
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess(new HeaderAndBody(new byte[0], new HashMap<String, Object>(1)));
            }
        });
    }

    @Override
    public void logout(final Callback<Void> callback) {
        this.clearPassword(this.auth.getPassword());
        this.auth = new PasswordAuthentication("", new char[0]);
        this.isLoggedIn = false;
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CookieStore store = ((CookieManager)CookieManager.getDefault()).getCookieStore();
                    List<HttpCookie> cookies = store.get(HttpBasicAuthenticationModule.this.baseURL.toURI());
                    for (HttpCookie cookie : cookies) {
                        store.remove(HttpBasicAuthenticationModule.this.baseURL.toURI(), cookie);
                    }
                    callback.onSuccess(null);
                }
                catch (URISyntaxException e) {
                    callback.onFailure(e);
                }
            }
        });
    }

    @Override
    public void enroll(Map<String, String> userData, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(new UnsupportedOperationException());
            }
        });
    }

    @Override
    public AuthorizationFields getAuthorizationFields() {
        AuthorizationFields fields = new AuthorizationFields();
        ArrayList<Pair<String, String>> headerList = new ArrayList<Pair<String, String>>(1);
        headerList.add(new Pair((Object)BASIC_HEADER, (Object)this.getHashedAuth()));
        fields.setHeaders(headerList);
        return fields;
    }

    @Override
    public AuthorizationFields getAuthorizationFields(URI requestUri, String method, byte[] requestBody) {
        return this.getAuthorizationFields();
    }

    @Override
    public boolean retryLogin() {
        return false;
    }

    private String getHashedAuth() {
        StringBuilder headerValueBuilder = new StringBuilder(AUTHORIZATION_METHOD).append(" ");
        String unhashedCredentials = this.auth.getUserName() + ":" + this.auth.getPassword();
        String hashedCrentials = Base64.encodeToString((byte[])unhashedCredentials.getBytes(), (int)0);
        return headerValueBuilder.append(hashedCrentials).toString();
    }

    private void clearPassword(char[] password) {
        for (int i = 0; i < password.length; ++i) {
            password[i] = 48;
        }
    }
}

