/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.aerogear.android.impl.reflection.Property;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.TypeAndStream;

public class MultipartRequestBuilder<T>
implements RequestBuilder<T> {
    private static final String TAG = MultipartRequestBuilder.class.getSimpleName();
    private static final String lineEnd = "\r\n";
    private static final String twoHyphens = "--";
    private final String boundary = UUID.randomUUID().toString();
    private final String CONTENT_TYPE = "multipart/form-data; boundary=" + this.boundary;
    private final String OCTECT_STREAM_MIME_TYPE = "application/octet-stream";

    @Override
    public byte[] getBody(T data) {
        ByteArrayOutputStream binaryStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(binaryStream);
        try {
            List<Property> properties = this.getProperties(data.getClass());
            HashMap<String, String> fields = new HashMap<String, String>(properties.size());
            HashMap<String, TypeAndStream> files = new HashMap<String, TypeAndStream>(properties.size());
            for (Property property : properties) {
                Object value = property.getValue(data);
                if (value == null) continue;
                if (value.getClass().isPrimitive() || value instanceof String) {
                    fields.put(property.getFieldName(), value.toString());
                    continue;
                }
                if (value instanceof byte[]) {
                    files.put(property.getFieldName(), new TypeAndStream("application/octet-stream", property.getFieldName(), new ByteArrayInputStream((byte[])value)));
                    continue;
                }
                if (value instanceof InputStream) {
                    files.put(property.getFieldName(), new TypeAndStream("application/octet-stream", property.getFieldName(), (InputStream)value));
                    continue;
                }
                if (value instanceof File) {
                    files.put(property.getFieldName(), new TypeAndStream(this.getMimeType((File)value), ((File)value).getName(), new FileInputStream((File)value)));
                    continue;
                }
                if (value instanceof TypeAndStream) {
                    files.put(property.getFieldName(), (TypeAndStream)value);
                    continue;
                }
                throw new IllegalArgumentException(property.getFieldName() + " is not a supported type for Multipart uplaod");
            }
            for (Map.Entry entry : fields.entrySet()) {
                this.setField(dataOutputStream, (String)entry.getKey(), entry.getValue());
            }
            if (files.size() == 1) {
                int b;
                Map.Entry pair = files.entrySet().iterator().next();
                TypeAndStream typeAndStream = (TypeAndStream)pair.getValue();
                String name = (String)pair.getKey();
                dataOutputStream.writeBytes(twoHyphens + this.boundary + lineEnd);
                dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + typeAndStream.getFileName() + "\"" + lineEnd);
                dataOutputStream.writeBytes("Content-Type: " + typeAndStream.getMimeType() + lineEnd);
                dataOutputStream.writeBytes("Content-Transfer-Encoding: binary\r\n");
                dataOutputStream.writeBytes(lineEnd);
                while ((b = typeAndStream.getInputStream().read()) != -1) {
                    dataOutputStream.write(b);
                }
                dataOutputStream.writeBytes(lineEnd);
            } else if (files.size() > 1) {
                String newBoundary = UUID.randomUUID().toString();
                dataOutputStream.writeBytes(twoHyphens + this.boundary + lineEnd);
                dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"files\"\r\n");
                dataOutputStream.writeBytes("Content-Type: multipart/mixed; boundary=" + newBoundary + lineEnd);
                dataOutputStream.writeBytes(lineEnd);
                for (Map.Entry file : files.entrySet()) {
                    int b;
                    TypeAndStream type = (TypeAndStream)file.getValue();
                    dataOutputStream.writeBytes(twoHyphens + newBoundary + lineEnd);
                    dataOutputStream.writeBytes("Content-Disposition: file; filename=\"" + type.getFileName() + "\"" + lineEnd);
                    dataOutputStream.writeBytes("Content-Type: " + type.getMimeType() + lineEnd);
                    dataOutputStream.writeBytes("Content-Transfer-Encoding: binary\r\n");
                    dataOutputStream.writeBytes(lineEnd);
                    while ((b = type.getInputStream().read()) != -1) {
                        dataOutputStream.write(b);
                    }
                    dataOutputStream.writeBytes(lineEnd);
                }
                dataOutputStream.writeBytes(twoHyphens + newBoundary + twoHyphens + lineEnd);
            }
            dataOutputStream.writeBytes(twoHyphens + this.boundary + twoHyphens + lineEnd);
            return binaryStream.toByteArray();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    private List<Property> getProperties(Class<? extends Object> baseClass) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Field field : baseClass.getDeclaredFields()) {
            Property property = new Property(baseClass, field.getName());
            properties.add(property);
        }
        return properties;
    }

    @Override
    public String getContentType() {
        return this.CONTENT_TYPE;
    }

    private void setField(DataOutputStream dataOutputStream, String name, Object value) throws IOException {
        dataOutputStream.writeBytes(twoHyphens + this.boundary + lineEnd);
        dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"" + lineEnd);
        dataOutputStream.writeBytes("Content-Type: text/plain; charset=US-ASCII\r\n");
        dataOutputStream.writeBytes("Content-Transfer-Encoding: 8bit\r\n");
        dataOutputStream.writeBytes(lineEnd);
        dataOutputStream.writeBytes(value.toString() + lineEnd);
    }

    private String getMimeType(File file) throws MalformedURLException {
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)file.toURI().toURL().toString());
        return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
    }
}

