/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.AsyncTask;
import android.util.Log;
import android.util.Pair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.datamanager.StoreType;
import org.jboss.aerogear.android.impl.datamanager.DefaultIdGenerator;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;
import org.jboss.aerogear.android.impl.reflection.Property;
import org.jboss.aerogear.android.impl.reflection.Scan;

public class SQLStore<T>
extends SQLiteOpenHelper
implements Store<T> {
    private static final String TAG = SQLStore.class.getSimpleName();
    private final Class<T> klass;
    private final String className;
    private static final String CREATE_PROPERTIES_TABLE = "create table if not exists %s_property  ( _ID integer primary key autoincrement,  PARENT_ID text not null,  PROPERTY_NAME text not null,  PROPERTY_VALUE text )";
    private static final String CREATE_PROPERTIES_INDEXES = "create index  if not exists %s_property_name_index  ON %s_property (PROPERTY_NAME);create index if not exists %s_property_name_value_index  ON %s_property (PROPERTY_NAME, PROPERTY_VALUE) ;create index  if not exists %s_property_parent_index  ON %s_property (PARENT_ID);";
    private SQLiteDatabase database;
    private final Gson gson;
    private final IdGenerator generator;

    public SQLStore(Class<T> klass, Context context) {
        super(context, klass.getSimpleName(), null, 1);
        this.klass = klass;
        this.className = klass.getSimpleName();
        this.gson = new Gson();
        this.generator = new DefaultIdGenerator();
    }

    public SQLStore(Class<T> klass, Context context, GsonBuilder builder, IdGenerator generator) {
        super(context, klass.getSimpleName(), null, 1);
        this.klass = klass;
        this.className = klass.getSimpleName();
        this.gson = builder.create();
        this.generator = generator;
    }

    @Override
    public StoreType getType() {
        return StoreTypes.SQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> readAll() {
        String sql = String.format("Select PROPERTY_NAME, PROPERTY_VALUE,PARENT_ID from %s_property", this.className);
        Cursor cursor = this.database.rawQuery(sql, new String[0]);
        HashMap<Integer, JsonObject> objects = new HashMap<Integer, JsonObject>(cursor.getCount());
        try {
            while (cursor.moveToNext()) {
                Integer id2 = cursor.getInt(2);
                JsonObject object = (JsonObject)objects.get(id2);
                if (object == null) {
                    object = new JsonObject();
                    objects.put(id2, object);
                }
                this.add(object, cursor.getString(0), cursor.getString(1));
            }
        }
        finally {
            cursor.close();
        }
        ArrayList<Object> data = new ArrayList<Object>(cursor.getCount());
        for (JsonObject object : objects.values()) {
            data.add(this.gson.fromJson((JsonElement)object, this.klass));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Serializable id2) {
        String sql = String.format("Select PROPERTY_NAME, PROPERTY_VALUE from %s_property where PARENT_ID = ?", this.className);
        String[] bindArgs = new String[]{id2.toString()};
        JsonObject result = new JsonObject();
        Cursor cursor = this.database.rawQuery(sql, bindArgs);
        if (cursor.getCount() == 0) {
            return null;
        }
        try {
            while (cursor.moveToNext()) {
                this.add(result, cursor.getString(0), cursor.getString(1));
            }
        }
        finally {
            cursor.close();
        }
        return (T)this.gson.fromJson((JsonElement)result, this.klass);
    }

    @Override
    public List<T> readWithFilter(ReadFilter filter) {
        if (filter == null) {
            filter = new ReadFilter();
        }
        String sql = String.format("select PARENT_ID from %s_property where PROPERTY_NAME = ? and PROPERTY_VALUE = ?", this.className);
        JsonObject where = (JsonObject)new JsonParser().parse(filter.getWhere().toString());
        ArrayList<Pair<String, String>> queryList = new ArrayList<Pair<String, String>>();
        HashMap<String, AtomicInteger> resultCount = new HashMap<String, AtomicInteger>();
        this.buildKeyValuePairs(where, queryList, "");
        if (queryList.isEmpty()) {
            return new ArrayList<T>(this.readAll());
        }
        for (Pair pair : queryList) {
            String[] bindArgs = new String[]{(String)pair.first, (String)pair.second};
            Cursor cursor = this.database.rawQuery(sql, bindArgs);
            while (cursor.moveToNext()) {
                String id2 = cursor.getString(0);
                AtomicInteger count = (AtomicInteger)resultCount.get(id2);
                if (count == null) {
                    count = new AtomicInteger(0);
                    resultCount.put(id2, count);
                }
                count.incrementAndGet();
            }
        }
        ArrayList<T> results = new ArrayList<T>();
        for (String id3 : resultCount.keySet()) {
            if (((AtomicInteger)resultCount.get(id3)).get() != queryList.size()) continue;
            results.add(this.read((Serializable)((Object)id3)));
        }
        return results;
    }

    @Override
    public void save(T item) {
        String recordIdFieldName = Scan.recordIdFieldNameIn(item.getClass());
        Property property = new Property(item.getClass(), recordIdFieldName);
        Serializable idValue = (Serializable)property.getValue(item);
        if (idValue == null) {
            idValue = this.generator.generate();
            property.setValue(item, idValue);
        }
        JsonObject serialized = (JsonObject)this.gson.toJsonTree(item, this.klass);
        this.saveElement(serialized, "", idValue);
    }

    private void saveElement(JsonObject serialized, String path, Serializable id2) {
        String sql = String.format("insert into %s_property (PROPERTY_NAME, PROPERTY_VALUE, PARENT_ID) values (?,?,?)", this.className);
        Set members = serialized.entrySet();
        String pathVar = path.isEmpty() ? "" : ".";
        for (Map.Entry member : members) {
            JsonElement jsonValue = (JsonElement)member.getValue();
            String propertyName = (String)member.getKey();
            if (jsonValue.isJsonObject()) {
                this.saveElement((JsonObject)jsonValue, path + pathVar + propertyName, id2);
                continue;
            }
            if (jsonValue.isJsonPrimitive()) {
                Object value;
                JsonPrimitive primitive = jsonValue.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    value = primitive.getAsBoolean() ? 1 : 0;
                    this.database.execSQL(sql, new Object[]{path + pathVar + propertyName, value, id2});
                    continue;
                }
                if (primitive.isNumber()) {
                    value = primitive.getAsNumber();
                    this.database.execSQL(sql, new Object[]{path + pathVar + propertyName, value, id2});
                    continue;
                }
                if (primitive.isString()) {
                    value = primitive.getAsString();
                    this.database.execSQL(sql, new Object[]{path + pathVar + propertyName, value, id2});
                    continue;
                }
                throw new IllegalArgumentException(jsonValue + " isn't a number, boolean, or string");
            }
            throw new IllegalArgumentException(jsonValue + " isn't a JsonPrimitive");
        }
    }

    @Override
    public void reset() {
        String sql = String.format("Delete from %s_property", this.className);
        this.database.execSQL(sql);
    }

    @Override
    public boolean isEmpty() {
        String sql = String.format("Select count(_ID) from %s_property", this.className);
        Cursor cursor = this.database.rawQuery(sql, null);
        cursor.moveToFirst();
        boolean result = cursor.getInt(0) == 0;
        cursor.close();
        return result;
    }

    @Override
    public void remove(Serializable id2) {
        String sql = String.format("Delete from %s_property where PARENT_ID = ?", this.className);
        Object[] bindArgs = new Object[]{id2};
        this.database.execSQL(sql, bindArgs);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(String.format(CREATE_PROPERTIES_TABLE, this.className));
        db.execSQL(String.format(CREATE_PROPERTIES_INDEXES, this.className, this.className, this.className, this.className, this.className, this.className));
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public void open(final Callback onReady) {
        new AsyncTask<Void, Void, Void>(){
            private Exception exception;

            protected Void doInBackground(Void ... params) {
                try {
                    SQLStore.this.database = SQLStore.this.getWritableDatabase();
                    onReady.onSuccess(this);
                }
                catch (Exception e) {
                    this.exception = e;
                    Log.e((String)TAG, (String)"There was an error loading the database", (Throwable)e);
                }
                return null;
            }

            protected void onPostExecute(Void result) {
                if (this.exception != null) {
                    onReady.onFailure(this.exception);
                } else {
                    onReady.onSuccess(SQLStore.this);
                }
            }
        }.execute((Object[])new Void[]{null});
    }

    public void close() {
        this.database.close();
    }

    private void add(JsonObject result, String propertyName, String propertyValue) {
        if (!propertyName.contains(".")) {
            result.addProperty(propertyName, propertyValue);
        } else {
            String[] names = propertyName.split("\\.", 2);
            JsonObject subObject = (JsonObject)result.get(names[0]);
            if (subObject == null) {
                subObject = new JsonObject();
                result.add(names[0], (JsonElement)subObject);
            }
            this.add(subObject, names[1], propertyValue);
        }
    }

    private void buildKeyValuePairs(JsonObject where, List<Pair<String, String>> keyValues, String parentPath) {
        Set keys = where.entrySet();
        String pathVar = parentPath.isEmpty() ? "" : ".";
        for (Map.Entry entry : keys) {
            String key = (String)entry.getKey();
            String path = parentPath + pathVar + key;
            JsonElement jsonValue = (JsonElement)entry.getValue();
            if (jsonValue.isJsonObject()) {
                this.buildKeyValuePairs((JsonObject)jsonValue, keyValues, path);
                continue;
            }
            if (jsonValue.isJsonPrimitive()) {
                Object value;
                JsonPrimitive primitive = jsonValue.getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    value = primitive.getAsBoolean() ? 1 : 0;
                    keyValues.add((Pair<String, String>)new Pair((Object)path, (Object)((Integer)value).toString()));
                    continue;
                }
                if (primitive.isNumber()) {
                    value = primitive.getAsNumber();
                    keyValues.add((Pair<String, String>)new Pair((Object)path, (Object)value.toString()));
                    continue;
                }
                if (primitive.isString()) {
                    value = primitive.getAsString();
                    keyValues.add((Pair<String, String>)new Pair((Object)path, value));
                    continue;
                }
                throw new IllegalArgumentException(jsonValue + " isn't a number, boolean, or string");
            }
            throw new IllegalArgumentException(jsonValue + " isn't a JsonPrimitive");
        }
    }
}

