/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.util.Log;
import android.util.Pair;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.client.utils.URIUtils;
import org.jboss.aerogear.android.Provider;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.authentication.AuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.http.HttpException;
import org.jboss.aerogear.android.http.HttpProvider;
import org.jboss.aerogear.android.impl.core.HttpProviderFactory;
import org.jboss.aerogear.android.impl.pipeline.GsonRequestBuilder;
import org.jboss.aerogear.android.impl.pipeline.GsonResponseParser;
import org.jboss.aerogear.android.impl.pipeline.PipeConfig;
import org.jboss.aerogear.android.impl.pipeline.paging.DefaultParameterProvider;
import org.jboss.aerogear.android.impl.pipeline.paging.URIBodyPageParser;
import org.jboss.aerogear.android.impl.pipeline.paging.URIPageHeaderParser;
import org.jboss.aerogear.android.impl.pipeline.paging.WebLink;
import org.jboss.aerogear.android.impl.pipeline.paging.WrappingPagedList;
import org.jboss.aerogear.android.impl.reflection.Property;
import org.jboss.aerogear.android.impl.reflection.Scan;
import org.jboss.aerogear.android.impl.util.ParseException;
import org.jboss.aerogear.android.impl.util.WebLinkParser;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.ResponseParser;
import org.jboss.aerogear.android.pipeline.paging.PageConfig;
import org.jboss.aerogear.android.pipeline.paging.ParameterProvider;
import org.json.JSONObject;

public class RestRunner<T>
implements PipeHandler<T> {
    private final PageConfig pageConfig;
    private static final String TAG = RestRunner.class.getSimpleName();
    private final RequestBuilder<T> requestBuilder;
    private final String dataRoot;
    private final ParameterProvider parameterProvider;
    private final Class<T> klass;
    private final Class<T[]> arrayKlass;
    private final URL baseURL;
    private final Provider<HttpProvider> httpProviderFactory = new HttpProviderFactory();
    private final Integer timeout;
    private final ResponseParser<T> responseParser;
    private AuthenticationModule authModule;
    private Charset encoding = Charset.forName("UTF-8");

    public RestRunner(Class<T> klass, URL baseURL) {
        this.klass = klass;
        this.arrayKlass = this.asArrayClass(klass);
        this.baseURL = baseURL;
        this.dataRoot = "";
        this.requestBuilder = new GsonRequestBuilder();
        this.pageConfig = null;
        this.parameterProvider = new DefaultParameterProvider();
        this.timeout = Integer.MAX_VALUE;
        this.responseParser = new GsonResponseParser();
    }

    public RestRunner(Class<T> klass, URL baseURL, PipeConfig config) {
        this.klass = klass;
        this.arrayKlass = this.asArrayClass(klass);
        this.baseURL = baseURL;
        this.timeout = config.getTimeout();
        this.requestBuilder = config.getRequestBuilder() != null ? config.getRequestBuilder() : new GsonRequestBuilder();
        this.encoding = config.getEncoding() != null ? config.getEncoding() : Charset.forName("UTF-8");
        this.dataRoot = config.getDataRoot() != null ? config.getDataRoot() : "";
        this.responseParser = config.getResponseParser() != null ? config.getResponseParser() : new GsonResponseParser();
        if (config.getPageConfig() != null) {
            this.pageConfig = config.getPageConfig();
            this.parameterProvider = this.pageConfig.getParameterProvider() != null ? this.pageConfig.getParameterProvider() : new DefaultParameterProvider();
            if (this.pageConfig.getPageParameterExtractor() == null) {
                if (PageConfig.MetadataLocations.BODY.equals(this.pageConfig.getMetadataLocation())) {
                    this.pageConfig.setPageParameterExtractor(new URIBodyPageParser(baseURL));
                } else if (PageConfig.MetadataLocations.HEADERS.equals(this.pageConfig.getMetadataLocation())) {
                    this.pageConfig.setPageParameterExtractor(new URIPageHeaderParser(baseURL));
                }
            }
        } else {
            this.pageConfig = null;
            this.parameterProvider = new DefaultParameterProvider();
        }
        if (config.getAuthModule() != null) {
            this.authModule = config.getAuthModule();
        }
    }

    @Override
    public List<T> onRead(Pipe<T> requestingPipe) {
        return this.onReadWithFilter(new ReadFilter(), requestingPipe);
    }

    @Override
    public T onSave(T data) {
        String recordIdFieldName = Scan.recordIdFieldNameIn(data.getClass());
        Object idObject = new Property(data.getClass(), recordIdFieldName).getValue(data);
        String id2 = idObject == null ? null : idObject.toString();
        byte[] body = this.requestBuilder.getBody(data);
        HttpProvider httpProvider = this.getHttpProvider();
        HeaderAndBody result = id2 == null || id2.length() == 0 ? httpProvider.post(body) : httpProvider.put(id2, body);
        return this.responseParser.handleResponse(new String(result.getBody(), this.encoding), this.klass);
    }

    @Override
    public List<T> onReadWithFilter(ReadFilter filter, Pipe<T> requestingPipe) {
        List<T> result;
        HeaderAndBody httpResponse;
        if (filter == null) {
            filter = new ReadFilter();
        }
        HttpProvider httpProvider = filter.getLinkUri() == null ? this.getHttpProvider(this.parameterProvider.getParameters(filter)) : this.getHttpProvider(filter.getLinkUri());
        try {
            httpResponse = httpProvider.get();
        }
        catch (HttpException exception) {
            if (exception.getStatusCode() == 401 && this.retryAuth(this.authModule)) {
                httpResponse = httpProvider.get();
            }
            throw exception;
        }
        byte[] responseBody = httpResponse.getBody();
        String responseAsString = new String(responseBody, this.encoding);
        JsonParser parser = new JsonParser();
        JsonElement httpJsonResult = parser.parse(responseAsString);
        httpJsonResult = this.getResultElement(httpJsonResult, this.dataRoot);
        if (httpJsonResult.isJsonArray()) {
            T[] resultArray = this.responseParser.handleArrayResponse(httpJsonResult.toString(), this.arrayKlass);
            result = Arrays.asList(resultArray);
            if (this.pageConfig != null) {
                result = this.computePagedList(result, httpResponse, filter.getWhere(), requestingPipe);
            }
        } else {
            T resultObject = this.responseParser.handleResponse(httpJsonResult.toString(), this.klass);
            ArrayList<T> resultList = new ArrayList<T>(1);
            resultList.add(resultObject);
            result = resultList;
            if (this.pageConfig != null) {
                result = this.computePagedList(result, httpResponse, filter.getWhere(), requestingPipe);
            }
        }
        return result;
    }

    @Override
    public void onRemove(String id2) {
        HttpProvider httpProvider = this.getHttpProvider();
        httpProvider.delete(id2);
    }

    private Class<T[]> asArrayClass(Class<T> klass) {
        return Array.newInstance(klass, 1).getClass();
    }

    private URL addAuthorization(List<Pair<String, String>> queryParameters, URL baseURL) {
        StringBuilder queryBuilder = new StringBuilder();
        String amp = "";
        for (Pair<String, String> parameter : queryParameters) {
            try {
                queryBuilder.append(amp).append(URLEncoder.encode((String)parameter.first, "UTF-8")).append("=").append(URLEncoder.encode((String)parameter.second, "UTF-8"));
                amp = "&";
            }
            catch (UnsupportedEncodingException ex) {
                Log.e((String)TAG, (String)"UTF-8 encoding is not supported.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return this.appendQuery(queryBuilder.toString(), baseURL);
    }

    private void addAuthHeaders(HttpProvider httpProvider, AuthorizationFields fields) {
        List<Pair<String, String>> authHeaders = fields.getHeaders();
        for (Pair<String, String> header : authHeaders) {
            httpProvider.setDefaultHeader((String)header.first, (String)header.second);
        }
    }

    private HttpProvider getHttpProvider() {
        return this.getHttpProvider(URI.create(""));
    }

    private HttpProvider getHttpProvider(URI relativeUri) {
        try {
            AuthorizationFields fields = this.loadAuth(relativeUri, "GET");
            URL authorizedURL = this.addAuthorization(fields.getQueryParameters(), URIUtils.resolve((URI)this.baseURL.toURI(), (URI)relativeUri).toURL());
            HttpProvider httpProvider = this.httpProviderFactory.get(authorizedURL, this.timeout);
            httpProvider.setDefaultHeader("Content-TYpe", this.requestBuilder.getContentType());
            this.addAuthHeaders(httpProvider, fields);
            return httpProvider;
        }
        catch (MalformedURLException ex) {
            Log.e((String)TAG, (String)("error resolving " + this.baseURL + " with " + relativeUri), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (URISyntaxException ex) {
            Log.e((String)TAG, (String)("error resolving " + this.baseURL + " with " + relativeUri), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private AuthorizationFields loadAuth(URI relativeURI, String httpMethod) {
        if (this.authModule != null && this.authModule.isLoggedIn()) {
            return this.authModule.getAuthorizationFields(relativeURI, httpMethod, new byte[0]);
        }
        return new AuthorizationFields();
    }

    private List<T> computePagedList(List<T> result, HeaderAndBody httpResponse, JSONObject where, Pipe<T> requestingPipe) {
        ReadFilter previousRead = null;
        ReadFilter nextRead = null;
        if (PageConfig.MetadataLocations.WEB_LINKING.equals(this.pageConfig.getMetadataLocation())) {
            String webLinksRaw = "";
            String relHeader = "rel";
            String nextIdentifier = this.pageConfig.getNextIdentifier();
            String prevIdentifier = this.pageConfig.getPreviousIdentifier();
            try {
                webLinksRaw = this.getWebLinkHeader(httpResponse);
                if (webLinksRaw == null) {
                    return result;
                }
                List<WebLink> webLinksParsed = WebLinkParser.parse(webLinksRaw);
                for (WebLink link : webLinksParsed) {
                    if (nextIdentifier.equals(link.getParameters().get("rel"))) {
                        nextRead = new ReadFilter();
                        nextRead.setLinkUri(new URI(link.getUri()));
                        continue;
                    }
                    if (!prevIdentifier.equals(link.getParameters().get("rel"))) continue;
                    previousRead = new ReadFilter();
                    previousRead.setLinkUri(new URI(link.getUri()));
                }
            }
            catch (URISyntaxException ex) {
                Log.e((String)TAG, (String)(webLinksRaw + " did not contain a valid context URI"), (Throwable)ex);
                throw new RuntimeException(ex);
            }
            catch (ParseException ex) {
                Log.e((String)TAG, (String)(webLinksRaw + " could not be parsed as a web link header"), (Throwable)ex);
                throw new RuntimeException(ex);
            }
        } else if (this.pageConfig.getMetadataLocation().equals(PageConfig.MetadataLocations.HEADERS)) {
            nextRead = this.pageConfig.getPageParameterExtractor().getNextFilter(httpResponse, this.pageConfig);
            previousRead = this.pageConfig.getPageParameterExtractor().getPreviousFilter(httpResponse, this.pageConfig);
        } else if (this.pageConfig.getMetadataLocation().equals(PageConfig.MetadataLocations.BODY)) {
            nextRead = this.pageConfig.getPageParameterExtractor().getNextFilter(httpResponse, this.pageConfig);
            previousRead = this.pageConfig.getPageParameterExtractor().getPreviousFilter(httpResponse, this.pageConfig);
        } else {
            throw new IllegalStateException("Not supported");
        }
        if (nextRead != null) {
            nextRead.setWhere(where);
        }
        if (previousRead != null) {
            previousRead.setWhere(where);
        }
        return new WrappingPagedList<T>(requestingPipe, result, nextRead, previousRead);
    }

    private String getWebLinkHeader(HeaderAndBody httpResponse) {
        String linkHeaderName = "Link";
        Object header = httpResponse.getHeader(linkHeaderName);
        if (header != null) {
            return header.toString();
        }
        return null;
    }

    public void setAuthenticationModule(AuthenticationModule module) {
        this.authModule = module;
    }

    private URL appendQuery(String query, URL baseURL) {
        try {
            URI baseURI = baseURL.toURI();
            String baseQuery = baseURI.getQuery();
            if (baseQuery == null || baseQuery.isEmpty()) {
                baseQuery = query;
            } else if (query != null && !query.isEmpty()) {
                baseQuery = baseQuery + "&" + query;
            }
            return new URI(baseURI.getScheme(), baseURI.getUserInfo(), baseURI.getHost(), baseURI.getPort(), baseURI.getPath(), baseQuery, baseURI.getFragment()).toURL();
        }
        catch (MalformedURLException ex) {
            Log.e((String)TAG, (String)("The URL could not be created from " + baseURL.toString()), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (URISyntaxException ex) {
            Log.e((String)TAG, (String)("Error turning " + query + " into URI query."), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    private JsonElement getResultElement(JsonElement element, String dataRoot) {
        String[] identifiers;
        for (String identifier : identifiers = dataRoot.split("\\.")) {
            if (identifier.equals("")) {
                return element;
            }
            JsonElement newElement = element.getAsJsonObject().get(identifier);
            if (newElement == null) {
                return element;
            }
            element = newElement;
        }
        return element;
    }

    void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public String getDataRoot() {
        return this.dataRoot;
    }

    protected RequestBuilder<T> getRequestBuilder() {
        return this.requestBuilder;
    }

    private boolean retryAuth(AuthenticationModule authModule) {
        return authModule != null && authModule.isLoggedIn() && authModule.retryLogin();
    }
}

