/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.unifiedpush;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import org.jboss.aerogear.android.unifiedpush.MessageHandler;
import org.jboss.aerogear.android.unifiedpush.Registrations;

public class AeroGearGCMMessageReceiver
extends BroadcastReceiver {
    public static final int NOTIFICATION_ID = 1;
    private static MessageHandler defaultHandler;
    private static boolean checkDefaultHandler;
    private static final String TAG;
    public static final String DEFAULT_MESSAGE_HANDLER_KEY = "DEFAULT_MESSAGE_HANDLER_KEY";

    public void onReceive(Context context, Intent intent) {
        if (checkDefaultHandler) {
            String defaultHandlerClassName;
            checkDefaultHandler = false;
            Bundle metaData = this.getMetadata(context);
            if (metaData != null && (defaultHandlerClassName = metaData.getString(DEFAULT_MESSAGE_HANDLER_KEY)) != null) {
                try {
                    Class<?> defaultHandlerClass = Class.forName(defaultHandlerClassName);
                    defaultHandler = (MessageHandler)defaultHandlerClass.newInstance();
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        Registrations.notifyHandlers(context, intent, defaultHandler);
    }

    private Bundle getMetadata(Context context) {
        ComponentName componentName = new ComponentName(context, AeroGearGCMMessageReceiver.class);
        try {
            ActivityInfo ai = context.getPackageManager().getReceiverInfo(componentName, 129);
            Bundle metaData = ai.metaData;
            if (metaData != null) {
                return metaData;
            }
            Log.d((String)TAG, (String)("metaData is null. Unable to get meta data for " + componentName));
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    static {
        checkDefaultHandler = true;
        TAG = AeroGearGCMMessageReceiver.class.getSimpleName();
    }
}

