/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import java.net.CookieManager;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AbstractAuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.authentication.impl.AGSecurityAuthenticationModuleRunner;
import org.jboss.aerogear.android.http.HeaderAndBody;

public final class AGSecurityAuthenticationModule
extends AbstractAuthenticationModule {
    private static final String TAG = AGSecurityAuthenticationModule.class.getSimpleName();
    private boolean isLoggedIn = false;
    private final AGSecurityAuthenticationModuleRunner runner;

    public AGSecurityAuthenticationModule(URL baseURL, AuthenticationConfig config) {
        this.runner = new AGSecurityAuthenticationModuleRunner(baseURL, config);
    }

    @Override
    public URL getBaseURL() {
        return this.runner.getBaseURL();
    }

    @Override
    public String getLoginEndpoint() {
        return this.runner.getLoginEndpoint();
    }

    @Override
    public String getLogoutEndpoint() {
        return this.runner.getLogoutEndpoint();
    }

    @Override
    public String getEnrollEndpoint() {
        return this.runner.getEnrollEndpoint();
    }

    @Override
    public void enroll(final Map<String, String> userData, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = AGSecurityAuthenticationModule.this.runner.onEnroll(userData);
                    AGSecurityAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"error enrolling", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void login(String username, String password, Callback<HeaderAndBody> callback) {
        HashMap<String, String> loginData = new HashMap<String, String>(2);
        loginData.put("loginName", username);
        loginData.put("password", password);
        this.login(loginData, callback);
    }

    @Override
    public void login(final Map<String, String> loginData, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = AGSecurityAuthenticationModule.this.runner.onLogin(loginData);
                    AGSecurityAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"error logging in", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void logout(final Callback<Void> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    AGSecurityAuthenticationModule.this.runner.onLogout();
                    CookieStore store = ((CookieManager)CookieManager.getDefault()).getCookieStore();
                    List<HttpCookie> cookies = store.get(AGSecurityAuthenticationModule.this.getBaseURL().toURI());
                    for (HttpCookie cookie : cookies) {
                        store.remove(AGSecurityAuthenticationModule.this.getBaseURL().toURI(), cookie);
                    }
                    AGSecurityAuthenticationModule.this.isLoggedIn = false;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    @Override
    public AuthorizationFields getAuthorizationFields() {
        AuthorizationFields fields = new AuthorizationFields();
        return fields;
    }

    @Override
    public AuthorizationFields getAuthorizationFields(URI requestUri, String method, byte[] requestBody) {
        return this.getAuthorizationFields();
    }

    @Override
    public boolean retryLogin() {
        return false;
    }
}

