/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.datamanager;

import android.content.Context;
import com.google.gson.GsonBuilder;
import org.jboss.aerogear.android.datamanager.IdGenerator;
import org.jboss.aerogear.android.datamanager.Store;
import org.jboss.aerogear.android.datamanager.StoreFactory;
import org.jboss.aerogear.android.datamanager.StoreType;
import org.jboss.aerogear.android.impl.datamanager.MemoryStorage;
import org.jboss.aerogear.android.impl.datamanager.SQLStore;
import org.jboss.aerogear.android.impl.datamanager.StoreConfig;
import org.jboss.aerogear.android.impl.datamanager.StoreTypes;

public final class DefaultStoreFactory
implements StoreFactory {
    @Override
    public Store createStore(StoreConfig config) {
        StoreType type = config.getType();
        IdGenerator idGenerator = config.getIdGenerator();
        Class klass = config.getKlass();
        Context context = config.getContext();
        GsonBuilder builder = config.getBuilder();
        if (type.equals(StoreTypes.MEMORY)) {
            return new MemoryStorage(idGenerator);
        }
        if (StoreTypes.SQL.equals(type)) {
            if (klass == null) {
                throw new IllegalArgumentException("StoreConfig.klass may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("StoreConfig.context may not be null");
            }
            if (builder == null) {
                throw new IllegalArgumentException("StoreConfig.builder may not be null");
            }
            return new SQLStore(klass, context, builder, idGenerator);
        }
        throw new IllegalArgumentException("Type is not supported yet");
    }
}

