/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.util;

import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public final class UrlUtils {
    private static final String TAG = UrlUtils.class.getSimpleName();

    private UrlUtils() {
    }

    public static URL appendToBaseURL(URL baseURL, String endpoint) {
        try {
            String baseString = baseURL.toString();
            if (!baseString.endsWith("/") && !endpoint.startsWith("/")) {
                baseString = baseString + "/";
            } else if (baseString.endsWith("/") && endpoint.startsWith("/")) {
                endpoint = endpoint.replaceFirst("/", "");
            }
            return new URL(baseString + endpoint);
        }
        catch (MalformedURLException ex) {
            String message = "Could not append " + endpoint + " to " + baseURL.toString();
            Log.e((String)TAG, (String)message, (Throwable)ex);
            throw new IllegalArgumentException(message, ex);
        }
    }

    public static URL appendQueryToBaseURL(URL baseURL, String query) {
        try {
            String baseString = baseURL.toString();
            if (baseString.endsWith("/")) {
                baseString = baseString.replaceAll("/$", "");
            }
            if (!query.startsWith("?")) {
                query = URLEncoder.encode(query, "UTF-8");
                query = "?" + query;
            } else {
                query = query.replaceFirst("[?]", "");
                query = URLEncoder.encode(query, "UTF-8");
                query = "?" + query;
            }
            return new URL(baseString + query);
        }
        catch (MalformedURLException ex) {
            String message = "Could not append " + query + " to " + baseURL.toString();
            Log.e((String)TAG, (String)message, (Throwable)ex);
            throw new IllegalArgumentException(message, ex);
        }
        catch (UnsupportedEncodingException ex) {
            String message = "UTF-8 is not a supported encoding";
            Log.e((String)TAG, (String)message, (Throwable)ex);
            throw new IllegalStateException(message, ex);
        }
    }
}

