/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.authentication.impl;

import android.util.Log;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.authentication.AbstractAuthenticationModule;
import org.jboss.aerogear.android.authentication.AuthenticationConfig;
import org.jboss.aerogear.android.authentication.AuthorizationFields;
import org.jboss.aerogear.android.authentication.impl.AGSecurityAuthenticationModule;
import org.jboss.aerogear.android.authentication.impl.DigestAuthenticationModuleRunner;
import org.jboss.aerogear.android.http.HeaderAndBody;

public class HttpDigestAuthenticationModule
extends AbstractAuthenticationModule {
    private static final String TAG = AGSecurityAuthenticationModule.class.getSimpleName();
    private boolean isLoggedIn = false;
    private final DigestAuthenticationModuleRunner runner;

    public HttpDigestAuthenticationModule(URL baseURL, AuthenticationConfig config) {
        this.runner = new DigestAuthenticationModuleRunner(baseURL, config);
    }

    @Override
    public URL getBaseURL() {
        return this.runner.getBaseURL();
    }

    @Override
    public String getLoginEndpoint() {
        return this.runner.getLoginEndpoint();
    }

    @Override
    public String getLogoutEndpoint() {
        return this.runner.getLogoutEndpoint();
    }

    @Override
    public String getEnrollEndpoint() {
        return this.runner.getEnrollEndpoint();
    }

    @Override
    public void enroll(final Map<String, String> userData, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = HttpDigestAuthenticationModule.this.runner.onEnroll(userData);
                    HttpDigestAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"error enrolling", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void login(final String username, final String password, final Callback<HeaderAndBody> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                HeaderAndBody result = null;
                Exception exception = null;
                try {
                    result = HttpDigestAuthenticationModule.this.runner.onLogin(username, password);
                    HttpDigestAuthenticationModule.this.isLoggedIn = true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void logout(final Callback<Void> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Exception exception = null;
                try {
                    HttpDigestAuthenticationModule.this.runner.onLogout();
                    HttpDigestAuthenticationModule.this.isLoggedIn = false;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"Error with Login", (Throwable)e);
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    @Override
    public AuthorizationFields getAuthorizationFields() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public AuthorizationFields getAuthorizationFields(URI requestUri, String method, byte[] requestBody) {
        AuthorizationFields fields = new AuthorizationFields();
        fields.addHeader("Authorization", this.runner.getAuthorizationHeader(requestUri, method, requestBody));
        return fields;
    }

    @Override
    public boolean retryLogin() {
        return this.runner.retryLogin();
    }

    @Override
    public void login(Map<String, String> loginData, Callback<HeaderAndBody> callback) {
        this.login(loginData.get("loginName"), loginData.get("password"), callback);
    }
}

