/**
 * JBoss, Home of Professional Open Source
 * Copyright Red Hat, Inc., and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.aerogear.android.pipeline;

import java.util.List;

import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.http.HeaderAndBody;

/**
 * Classes which implement this interface provide the logic for how pipes 
 * interact with services.
 */
public interface PipeHandler<T> {
    /**
     * This method is called after a call to read.  It performs the actual load of data
     * and returns.
     * 
     * @param requestingPipe the Pipe which is calling the this handler.
     * 
     * @return a List of data.
     * 
     */
    @Deprecated
    List<T> onRead(Pipe<T> requestingPipe);

    @Deprecated
    List<T> onReadWithFilter(ReadFilter filter, Pipe<T> requestingPipe);

    @Deprecated
    T onSave(T item);

    HeaderAndBody onRawRead(Pipe<T> requestingPipe);

    HeaderAndBody onRawReadWithFilter(ReadFilter filter, Pipe<T> requestingPipe);

    HeaderAndBody onRawSave(String id, byte[] item);

    void onRemove(String id);
}
