/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.authz;

public class OAuth2AuthorizationException
extends Exception {
    public final String error;
    public final Error type;

    public OAuth2AuthorizationException(String error) {
        super(error);
        this.error = error;
        this.type = Error.getErrorEnum(error);
    }

    public String getError() {
        return this.error;
    }

    public Error getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "AuthorizationException{error=" + this.error + '}';
    }

    public static enum Error {
        INVALID_REQUEST,
        INVALID_CLIENT,
        INVALID_GRANT,
        UNAUTHORIZED_CLIENT,
        UNSUPPORTED_GRANT_TYPE,
        INVALID_SCOPE,
        OTHER;


        public static Error getErrorEnum(String inError) {
            for (Error error : Error.values()) {
                if (!error.name().equalsIgnoreCase(inError)) continue;
                return error;
            }
            return OTHER;
        }
    }
}

