/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.aerogear.android.http.HeaderAndBody;
import org.jboss.aerogear.android.impl.util.ClassUtils;
import org.jboss.aerogear.android.pipeline.MarshallingConfig;
import org.jboss.aerogear.android.pipeline.ResponseParser;

public class GsonResponseParser<T>
implements ResponseParser<T> {
    private Gson gson;
    private MarshallingConfig marshallingConfig = new MarshallingConfig();

    public GsonResponseParser() {
        this.gson = new Gson();
    }

    public GsonResponseParser(Gson gson) {
        this.gson = gson;
    }

    @Override
    public T handleResponse(String response, Class<T> responseType) {
        return (T)this.gson.fromJson(response, responseType);
    }

    @Override
    public T[] handleArrayResponse(String response, Class<T[]> responseType) {
        return (Object[])this.gson.fromJson(response, responseType);
    }

    @Override
    public List<T> handleResponse(HeaderAndBody httpResponse, Class<T> responseType) {
        List<Object> result;
        byte[] responseBody = httpResponse.getBody();
        String responseAsString = new String(responseBody, this.marshallingConfig.getEncoding());
        JsonParser parser = new JsonParser();
        JsonElement httpJsonResult = parser.parse(responseAsString);
        if ((httpJsonResult = this.getResultElement(httpJsonResult, this.marshallingConfig.getDataRoot())).isJsonArray()) {
            Object[] resultArray = (Object[])this.gson.fromJson(httpJsonResult.toString(), ClassUtils.asArrayClass(responseType));
            result = Arrays.asList(resultArray);
        } else {
            Object resultObject = this.gson.fromJson(httpJsonResult.toString(), responseType);
            ArrayList<Object> resultList = new ArrayList<Object>(1);
            resultList.add(resultObject);
            result = resultList;
        }
        return result;
    }

    @Deprecated
    public Gson getGson() {
        return this.gson;
    }

    @Deprecated
    public void setGson(Gson gson) {
        this.gson = gson;
    }

    private JsonElement getResultElement(JsonElement element, String dataRoot) {
        String[] identifiers;
        for (String identifier : identifiers = dataRoot.split("\\.")) {
            if (identifier.equals("")) {
                return element;
            }
            JsonElement newElement = element.getAsJsonObject().get(identifier);
            if (newElement == null) {
                return element;
            }
            element = newElement;
        }
        return element;
    }

    @Override
    public MarshallingConfig getMarshallingConfig() {
        return this.marshallingConfig;
    }

    public void setMarshallingConfig(MarshallingConfig marshallingConfig) {
        this.marshallingConfig = marshallingConfig;
    }
}

