/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.pipeline;

import android.util.Log;
import com.google.gson.Gson;
import java.net.URL;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.android.Callback;
import org.jboss.aerogear.android.ReadFilter;
import org.jboss.aerogear.android.impl.pipeline.GsonRequestBuilder;
import org.jboss.aerogear.android.impl.pipeline.GsonResponseParser;
import org.jboss.aerogear.android.impl.pipeline.PipeConfig;
import org.jboss.aerogear.android.impl.pipeline.PipeTypes;
import org.jboss.aerogear.android.impl.pipeline.RestRunner;
import org.jboss.aerogear.android.pipeline.Pipe;
import org.jboss.aerogear.android.pipeline.PipeHandler;
import org.jboss.aerogear.android.pipeline.PipeType;
import org.jboss.aerogear.android.pipeline.RequestBuilder;
import org.jboss.aerogear.android.pipeline.ResponseParser;

public final class RestAdapter<T>
implements Pipe<T> {
    private static final String TAG = RestAdapter.class.getSimpleName();
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAX_POOL_SIZE = 64;
    private static final int KEEP_ALIVE = 1;
    private static final BlockingQueue<Runnable> WORK_QUEUE = new LinkedBlockingQueue<Runnable>(10);
    public static final Executor THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(5, 64, 1L, TimeUnit.SECONDS, WORK_QUEUE);
    private final Class<T> klass;
    private final URL url;
    private final PipeHandler<T> restRunner;
    private final RequestBuilder<T> requestBuilder;
    private final ResponseParser<T> responseParser;

    public RestAdapter(Class<T> klass, URL absoluteURL) {
        this.restRunner = new RestRunner<T>(klass, absoluteURL);
        this.klass = klass;
        this.url = absoluteURL;
        this.requestBuilder = new GsonRequestBuilder();
        this.responseParser = new GsonResponseParser();
    }

    public RestAdapter(Class<T> klass, URL absoluteURL, PipeConfig config) {
        this.klass = klass;
        this.url = absoluteURL;
        this.requestBuilder = config.getRequestBuilder();
        this.responseParser = config.getResponseParser();
        this.restRunner = config.getHandler() != null ? config.getHandler() : new RestRunner<T>(klass, absoluteURL, config);
    }

    @Override
    public PipeType getType() {
        return PipeTypes.REST;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public void readWithFilter(ReadFilter filter, Callback<List<T>> callback) {
        this.read(filter, callback);
    }

    @Override
    public void read(ReadFilter filter, final Callback<List<T>> callback) {
        if (filter == null) {
            filter = new ReadFilter();
        }
        final ReadFilter innerFilter = filter;
        THREAD_POOL_EXECUTOR.execute(new Runnable(){
            List<T> result = null;
            Exception exception = null;

            @Override
            public void run() {
                try {
                    this.result = RestAdapter.this.restRunner.onReadWithFilter(innerFilter, RestAdapter.this);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    this.exception = e;
                }
                if (this.exception == null) {
                    callback.onSuccess(this.result);
                } else {
                    callback.onFailure(this.exception);
                }
            }
        });
    }

    @Override
    public void read(final Callback<List<T>> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){
            List<T> result = null;
            Exception exception = null;

            @Override
            public void run() {
                try {
                    this.result = RestAdapter.this.restRunner.onRead(RestAdapter.this);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                    this.exception = e;
                }
                if (this.exception == null) {
                    callback.onSuccess(this.result);
                } else {
                    callback.onFailure(this.exception);
                }
            }
        });
    }

    @Override
    public void save(final T data, final Callback<T> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                Object result = null;
                Exception exception = null;
                try {
                    result = RestAdapter.this.restRunner.onSave(data);
                }
                catch (Exception e) {
                    exception = e;
                }
                if (exception == null) {
                    callback.onSuccess(result);
                } else {
                    callback.onFailure(exception);
                }
            }
        });
    }

    @Override
    public void remove(final String id2, final Callback<Void> callback) {
        THREAD_POOL_EXECUTOR.execute(new Runnable(){
            Exception exception = null;

            @Override
            public void run() {
                try {
                    RestAdapter.this.restRunner.onRemove(id2);
                }
                catch (Exception e) {
                    this.exception = e;
                }
                if (this.exception == null) {
                    callback.onSuccess(null);
                } else {
                    callback.onFailure(this.exception);
                }
            }
        });
    }

    @Override
    public PipeHandler<T> getHandler() {
        return this.restRunner;
    }

    @Override
    public Class<T> getKlass() {
        return this.klass;
    }

    @Override
    public Gson getGson() {
        return this.requestBuilder instanceof GsonRequestBuilder ? ((GsonRequestBuilder)this.requestBuilder).getGson() : null;
    }

    @Override
    public RequestBuilder<T> getRequestBuilder() {
        return this.requestBuilder;
    }

    @Override
    public ResponseParser<T> getResponseParser() {
        return this.responseParser;
    }
}

