/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.reflection;

import java.lang.reflect.Field;
import org.jboss.aerogear.android.RecordId;
import org.jboss.aerogear.android.impl.reflection.Property;
import org.jboss.aerogear.android.impl.reflection.RecordIdNotFoundException;

public final class Scan {
    private static Field recordIdFieldIn(Class klass) {
        for (Field field : klass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(RecordId.class)) continue;
            return field;
        }
        Class superclass = klass.getSuperclass();
        if (superclass != null) {
            return Scan.recordIdFieldIn(superclass);
        }
        throw new RecordIdNotFoundException(klass);
    }

    public static String recordIdFieldNameIn(Class klass) {
        return Scan.recordIdFieldIn(klass).getName();
    }

    public static String findIdValueIn(Object data) {
        String recordIdFieldName = Scan.recordIdFieldNameIn(data.getClass());
        Object idObject = new Property(data.getClass(), recordIdFieldName).getValue(data);
        String id2 = idObject == null ? null : idObject.toString();
        return id2;
    }
}

