/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.android.impl.security;

import android.content.Context;
import org.jboss.aerogear.android.impl.security.EncryptionServiceTypes;
import org.jboss.aerogear.android.impl.security.PassphraseEncryptionServices;
import org.jboss.aerogear.android.impl.security.PasswordEncryptionServices;
import org.jboss.aerogear.android.security.CryptoConfig;
import org.jboss.aerogear.android.security.EncryptionService;
import org.jboss.aerogear.android.security.EncryptionServiceFactory;

public class DefaultEncryptionServiceFactory
implements EncryptionServiceFactory {
    @Override
    public EncryptionService getService(CryptoConfig config, Context context) {
        if (EncryptionServiceTypes.PASSPHRASE.equals(config.getType())) {
            return this.makePassPhraseService(config, context);
        }
        if (EncryptionServiceTypes.PASSWORD_KEYSTORE.equals(config.getType())) {
            return this.makePasswordKeyStoreService(config, context);
        }
        throw new IllegalStateException("Unsupported CryptoConfig type");
    }

    private EncryptionService makePassPhraseService(CryptoConfig config, Context context) {
        return new PassphraseEncryptionServices(context, (PassphraseEncryptionServices.PassPhraseCryptoConfig)config);
    }

    private EncryptionService makePasswordKeyStoreService(CryptoConfig config, Context context) {
        return new PasswordEncryptionServices((PasswordEncryptionServices.PasswordProtectedKeystoreCryptoConfig)config, context);
    }
}

