/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.aerogear.controller.RequestMethod;
import org.jboss.aerogear.controller.router.Route;

public class DefaultRoute
implements Route {
    private final String path;
    private final Class<?> targetClass;
    private final Method targetMethod;
    private Set<RequestMethod> methods;

    public DefaultRoute(String path, RequestMethod[] methods, Class<?> targetClass, Method targetMethod) {
        this.path = path;
        this.methods = new HashSet<RequestMethod>(Arrays.asList(methods));
        this.targetClass = targetClass;
        this.targetMethod = targetMethod;
    }

    @Override
    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public boolean matches(RequestMethod method, String path) {
        return this.methods.contains((Object)method) && this.isPathCompatible(path);
    }

    private boolean isPathCompatible(String path) {
        if (this.isParameterized()) {
            int paramStart = this.path.indexOf(123);
            return this.path.subSequence(0, paramStart).equals(path.subSequence(0, paramStart));
        }
        return this.path.equals(path);
    }

    @Override
    public Method getTargetMethod() {
        return this.targetMethod;
    }

    @Override
    public boolean isParameterized() {
        return this.path.contains("{");
    }
}

