/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import br.com.caelum.iogi.Iogi;
import br.com.caelum.iogi.parameters.Parameter;
import br.com.caelum.iogi.reflection.Target;
import br.com.caelum.iogi.spi.DependencyProvider;
import br.com.caelum.iogi.spi.LocaleProvider;
import br.com.caelum.iogi.util.DefaultLocaleProvider;
import br.com.caelum.iogi.util.NullDependencyProvider;
import java.util.LinkedList;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.RequestMethod;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.router.ControllerFactory;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.Router;
import org.jboss.aerogear.controller.router.Routes;
import org.jboss.aerogear.controller.router.RoutingModule;
import org.jboss.aerogear.controller.util.StringUtils;
import org.jboss.aerogear.controller.view.View;
import org.jboss.aerogear.controller.view.ViewResolver;

public class DefaultRouter
implements Router {
    private Routes routes;
    private final BeanManager beanManager;
    private ViewResolver viewResolver;
    private Iogi iogi = new Iogi((DependencyProvider)new NullDependencyProvider(), (LocaleProvider)new DefaultLocaleProvider());
    private ControllerFactory controllerFactory;

    @Inject
    public DefaultRouter(RoutingModule routes, BeanManager beanManager, ViewResolver viewResolver, ControllerFactory controllerFactory) {
        this.routes = routes.build();
        this.beanManager = beanManager;
        this.viewResolver = viewResolver;
        this.controllerFactory = controllerFactory;
    }

    @Override
    public boolean hasRouteFor(HttpServletRequest httpServletRequest) {
        return this.routes.hasRouteFor(this.extractMethod(httpServletRequest), this.extractPath(httpServletRequest));
    }

    private String extractPath(HttpServletRequest httpServletRequest) {
        ServletContext servletContext = httpServletRequest.getServletContext();
        String contextPath = servletContext.getContextPath();
        return httpServletRequest.getRequestURI().substring(contextPath.length());
    }

    private RequestMethod extractMethod(HttpServletRequest httpServletRequest) {
        return RequestMethod.valueOf(httpServletRequest.getMethod());
    }

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException {
        try {
            String requestPath = this.extractPath(request);
            Route route = this.routes.routeFor(this.extractMethod(request), requestPath);
            Object[] params = route.isParameterized() ? this.extractPathParameters(requestPath, route) : this.extractParameters(request, route);
            Object result = route.getTargetMethod().invoke(this.getController(route), params);
            String viewPath = this.viewResolver.resolveViewPathFor(route);
            View view = new View(viewPath, result);
            if (view.hasModelData()) {
                request.setAttribute(view.getModelName(), view.getModel());
            }
            request.getRequestDispatcher(view.getViewPath()).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Object[] extractPathParameters(String requestPath, Route route) {
        int paramOffset = route.getPath().indexOf(123);
        CharSequence param = requestPath.subSequence(paramOffset, requestPath.length());
        return new Object[]{((Object)param).toString()};
    }

    private Object[] extractParameters(HttpServletRequest request, Route route) {
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value.length == 1) {
                parameters.add(new Parameter((String)entry.getKey(), value[0]));
                continue;
            }
            AeroGearLogger.LOGGER.multivaluedParamsUnsupported();
        }
        Class<?>[] parameterTypes = route.getTargetMethod().getParameterTypes();
        if (parameterTypes.length == 1) {
            Class<?> parameterType = parameterTypes[0];
            Target target = Target.create(parameterType, (String)StringUtils.downCaseFirst(parameterType.getSimpleName()));
            Object instantiate = this.iogi.instantiate(target, parameters.toArray(new Parameter[0]));
            return new Object[]{instantiate};
        }
        return new Object[0];
    }

    private Object getController(Route route) {
        return this.controllerFactory.createController(route.getTargetClass(), this.beanManager);
    }
}

