/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aerogear.controller.RequestMethod;
import org.jboss.aerogear.controller.log.AeroGearLogger;
import org.jboss.aerogear.controller.log.LoggerMessages;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteBuilder;
import org.jboss.aerogear.controller.router.RouteBuilderImpl;

public class Routes {
    private final List<Route> routes = new ArrayList<Route>();

    public Routes(List<RouteBuilder> routeBuilders) {
        for (RouteBuilder routeBuilder : routeBuilders) {
            this.routes.add(routeBuilder.build());
        }
    }

    public static RouteBuilder route() {
        return new RouteBuilderImpl();
    }

    public static Routes from(List<RouteBuilder> routes) {
        return new Routes(routes);
    }

    public String toString() {
        return "Routes{routes=" + this.routes + '}';
    }

    public boolean hasRouteFor(RequestMethod method, String requestURI) {
        AeroGearLogger.LOGGER.requestedRoute(method, requestURI);
        for (Route route : this.routes) {
            if (!route.matches(method, requestURI)) continue;
            return true;
        }
        return false;
    }

    public Route routeFor(RequestMethod method, String requestURI) {
        for (Route route : this.routes) {
            if (!route.matches(method, requestURI)) continue;
            return route;
        }
        throw LoggerMessages.MESSAGES.routeNotFound(method, requestURI);
    }
}

