/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.decorators;

import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.aerogear.controller.router.EndpointInvoker;
import org.jboss.aerogear.controller.router.InvocationResult;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.router.error.ErrorRoute;
import org.jboss.aerogear.controller.spi.HttpStatusAwareException;

@Decorator
public class ErrorHandler
implements RouteProcessor {
    private final RouteProcessor delegate;
    private EndpointInvoker endpointInvoker;

    @Inject
    public ErrorHandler(@Delegate RouteProcessor delegate, EndpointInvoker endpointInvoker) {
        this.delegate = delegate;
        this.endpointInvoker = endpointInvoker;
    }

    @Override
    public InvocationResult process(RouteContext routeContext) throws Exception {
        try {
            return this.delegate.process(routeContext);
        }
        catch (Throwable t) {
            if (t instanceof HttpStatusAwareException) {
                routeContext.getResponse().setStatus(((HttpStatusAwareException)((Object)t)).getStatus());
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            RouteContext errorContext = this.errorContext(rootCause, routeContext);
            Object result = this.invokeErrorMethod(errorContext, rootCause);
            routeContext.getRequest().setAttribute(ErrorRoute.DEFAULT.getExceptionAttrName(), (Object)rootCause);
            return new InvocationResult(result, errorContext);
        }
    }

    private Object invokeErrorMethod(RouteContext errorContext, Throwable rootCause) throws Exception {
        return this.endpointInvoker.invoke(errorContext, this.getMethodArguments(errorContext, rootCause));
    }

    private Object[] getMethodArguments(RouteContext routeContext, Throwable t) {
        Object[] objectArray;
        Method targetMethod = routeContext.getRoute().getTargetMethod();
        if (targetMethod.getParameterTypes().length == 0) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = t;
        }
        return objectArray;
    }

    private RouteContext errorContext(Throwable rootCause, RouteContext orgContext) {
        Route errorRoute = orgContext.getRoutes().routeFor(rootCause);
        return new RouteContext(errorRoute, this.wrapRequest(orgContext), orgContext.getResponse(), orgContext.getRoutes());
    }

    private HttpServletRequest wrapRequest(RouteContext routeContext) {
        final String acceptAny = this.appendAnyMediaTypeToAcceptHeader(routeContext.getRequest());
        return new HttpServletRequestWrapper(routeContext.getRequest()){

            public String getHeader(String name) {
                if (name.equalsIgnoreCase("accept")) {
                    return acceptAny;
                }
                return super.getHeader(name);
            }
        };
    }

    private String appendAnyMediaTypeToAcceptHeader(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        return acceptHeader == null ? "*/*" : acceptHeader + "," + "*/*";
    }
}

