/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.aerogear.controller.router.MediaType;
import org.jboss.aerogear.controller.router.Responder;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.view.View;
import org.jboss.aerogear.controller.view.ViewResolver;

public class MvcResponder
implements Responder {
    private ViewResolver viewResolver;

    @Inject
    public MvcResponder(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    @Override
    public boolean accepts(String mediaType) {
        return MediaType.HTML.toString().equals(mediaType) || MediaType.ANY.toString().equals(mediaType);
    }

    @Override
    public void respond(Object entity, RouteContext routeContext) throws Exception {
        String viewPath = this.viewResolver.resolveViewPathFor(routeContext.getRoute());
        View view = new View(viewPath, entity);
        if (view.hasModelData()) {
            routeContext.getRequest().setAttribute(view.getModelName(), view.getModel());
        }
        routeContext.getRequest().getRequestDispatcher(view.getViewPath()).forward((ServletRequest)routeContext.getRequest(), (ServletResponse)routeContext.getResponse());
    }
}

