/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.decorators;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.controller.router.ControllerFactory;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.router.error.ErrorRoute;
import org.jboss.aerogear.controller.spi.HttpStatusAwareException;
import org.jboss.aerogear.controller.view.ErrorViewResolver;
import org.jboss.aerogear.controller.view.View;
import org.jboss.aerogear.controller.view.ViewResolver;

@Decorator
public class ErrorHandler
implements RouteProcessor {
    private final RouteProcessor delegate;
    private final ControllerFactory controllerFactory;
    private final BeanManager beanManager;
    private final ViewResolver errorViewResolver;

    @Inject
    public ErrorHandler(@Delegate RouteProcessor delegate, ViewResolver viewResolver, ControllerFactory controllerFactory, BeanManager beanManager) {
        this.delegate = delegate;
        this.controllerFactory = controllerFactory;
        this.beanManager = beanManager;
        this.errorViewResolver = new ErrorViewResolver(viewResolver);
    }

    @Override
    public void process(RouteContext routeContext) throws Exception {
        try {
            this.delegate.process(routeContext);
        }
        catch (Throwable t) {
            if (t instanceof HttpStatusAwareException) {
                routeContext.getResponse().setStatus(((HttpStatusAwareException)((Object)t)).getStatus());
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            Route errorRoute = routeContext.getRoutes().routeFor(rootCause);
            this.invokeErrorRoute(errorRoute, rootCause);
            this.forwardErrorToView(errorRoute, rootCause, routeContext.getRequest(), routeContext.getResponse());
        }
    }

    private void invokeErrorRoute(Route errorRoute, Throwable t) throws ServletException {
        try {
            Method targetMethod = errorRoute.getTargetMethod();
            if (targetMethod.getParameterTypes().length == 0) {
                targetMethod.invoke(this.getController(errorRoute), new Object[0]);
            } else {
                targetMethod.invoke(this.getController(errorRoute), t);
            }
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private void forwardErrorToView(Route errorRoute, Throwable rootCause, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            View view = new View(this.errorViewResolver.resolveViewPathFor(errorRoute), rootCause);
            request.setAttribute(ErrorRoute.DEFAULT.getExceptionAttrName(), view.getModel());
            request.getRequestDispatcher(view.getViewPath()).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private Object getController(Route route) {
        return this.controllerFactory.createController(route.getTargetClass(), this.beanManager);
    }
}

