/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.aerogear.controller.router.Consumer;
import org.jboss.aerogear.controller.router.ControllerFactory;
import org.jboss.aerogear.controller.router.Responders;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.router.rest.pagination.Paginated;
import org.jboss.aerogear.controller.router.rest.pagination.Pagination;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationInfo;
import org.jboss.aerogear.controller.router.rest.pagination.PagingStrategy;
import org.jboss.aerogear.controller.util.ParameterExtractor;

public class DefaultRouteProcessor
implements RouteProcessor {
    private BeanManager beanManager;
    private ControllerFactory controllerFactory;
    private Responders responders;
    private final Map<String, Consumer> consumers = new HashMap<String, Consumer>();

    public DefaultRouteProcessor() {
    }

    @Inject
    public DefaultRouteProcessor(BeanManager beanManager, Instance<Consumer> consumers, Responders responders, ControllerFactory controllerFactory) {
        this.beanManager = beanManager;
        this.controllerFactory = controllerFactory;
        this.responders = responders;
        for (Consumer consumer : consumers) {
            this.consumers.put(consumer.mediaType(), consumer);
        }
    }

    @Override
    public void process(RouteContext routeContext) throws Exception {
        Route route = routeContext.getRoute();
        Map<String, Object> arguments = ParameterExtractor.extractArguments(routeContext, this.consumers);
        if (this.hasPaginatedAnnotation(route.getTargetMethod())) {
            this.processPaged(routeContext, arguments);
        } else {
            this.responders.respond(routeContext, route.getTargetMethod().invoke(this.getController(route), arguments.values().toArray()));
        }
    }

    private void processPaged(RouteContext routeContext, Map<String, Object> arguments) throws Exception {
        Route route = routeContext.getRoute();
        PagingStrategy pagingStrategy = this.getPagingStrategy(route, arguments);
        PaginationInfo paginationInfo = pagingStrategy.getPaginationInfo();
        List<Object> pagingArgs = this.merge(paginationInfo, arguments);
        Object result = route.getTargetMethod().invoke(this.getController(route), pagingArgs.toArray());
        this.responders.respond(routeContext, pagingStrategy.process(result, routeContext));
    }

    private List<Object> merge(PaginationInfo paginationInfo, Map<String, Object> arguments) {
        LinkedList<Object> methodArguments = new LinkedList<Object>();
        arguments.remove(paginationInfo.getOffsetParamName());
        arguments.remove(paginationInfo.getLimitParamName());
        methodArguments.add(paginationInfo);
        methodArguments.addAll(arguments.values());
        return methodArguments;
    }

    public PagingStrategy getPagingStrategy(Route route, Map<String, Object> args) {
        Paginated paginated = route.getTargetMethod().getAnnotation(Paginated.class);
        String customHeader = paginated.customHeadersPrefix();
        return Pagination.offset(paginated.offsetParamName(), this.argAsString(args, paginated.offsetParamName())).limitParam(paginated.limitParamName(), this.argAsString(args, paginated.limitParamName())).customHeadersPrefix(customHeader).webLinking(paginated.webLinking()).build();
    }

    private String argAsString(Map<String, Object> args, String argName) {
        return (String)args.get(argName);
    }

    private boolean hasPaginatedAnnotation(Method targetMethod) {
        return targetMethod.getAnnotation(Paginated.class) != null;
    }

    private Object getController(Route route) {
        return this.controllerFactory.createController(route.getTargetClass(), this.beanManager);
    }
}

