/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.decorators;

import com.google.common.base.Throwables;
import java.lang.reflect.Method;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletException;
import org.jboss.aerogear.controller.router.ControllerFactory;
import org.jboss.aerogear.controller.router.Responders;
import org.jboss.aerogear.controller.router.Route;
import org.jboss.aerogear.controller.router.RouteContext;
import org.jboss.aerogear.controller.router.RouteProcessor;
import org.jboss.aerogear.controller.router.error.ErrorRoute;
import org.jboss.aerogear.controller.spi.HttpStatusAwareException;

@Decorator
public class ErrorHandler
implements RouteProcessor {
    private final RouteProcessor delegate;
    private final ControllerFactory controllerFactory;
    private final BeanManager beanManager;
    private final Responders responders;

    @Inject
    public ErrorHandler(@Delegate RouteProcessor delegate, Responders responders, ControllerFactory controllerFactory, BeanManager beanManager) {
        this.delegate = delegate;
        this.controllerFactory = controllerFactory;
        this.beanManager = beanManager;
        this.responders = responders;
    }

    @Override
    public void process(RouteContext routeContext) throws Exception {
        try {
            this.delegate.process(routeContext);
        }
        catch (Throwable t) {
            if (t instanceof HttpStatusAwareException) {
                routeContext.getResponse().setStatus(((HttpStatusAwareException)((Object)t)).getStatus());
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            Route errorRoute = routeContext.getRoutes().routeFor(rootCause);
            RouteContext errorContext = new RouteContext(errorRoute, routeContext.getRequest(), routeContext.getResponse(), routeContext.getRoutes());
            Object result = this.invokeErrorRoute(errorContext, rootCause);
            routeContext.getRequest().setAttribute(ErrorRoute.DEFAULT.getExceptionAttrName(), (Object)rootCause);
            this.responders.respond(errorContext, result);
        }
    }

    private Object invokeErrorRoute(RouteContext routeContext, Throwable t) throws ServletException {
        Route errorRoute = routeContext.getRoute();
        Object response = null;
        try {
            Method targetMethod = errorRoute.getTargetMethod();
            response = targetMethod.getParameterTypes().length == 0 ? targetMethod.invoke(this.getController(errorRoute), new Object[0]) : targetMethod.invoke(this.getController(errorRoute), t);
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        return response != null ? response : t;
    }

    private Object getController(Route route) {
        return this.controllerFactory.createController(route.getTargetClass(), this.beanManager);
    }
}

