/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.router.decorators.cors;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.aerogear.controller.router.RequestMethod;
import org.jboss.aerogear.controller.router.decorators.cors.CorsConfiguration;

public class CorsConfig
implements CorsConfiguration {
    private final boolean corsSupportEnabled;
    private final String exposeHeaders;
    private final boolean anyOrigin;
    private final boolean allowCookies;
    private final long maxAge;
    private final Set<String> validRequestMethods;
    private final Set<String> validRequestHeaders;

    private CorsConfig(Builder builder) {
        this.corsSupportEnabled = builder.corsSupportEnabled;
        this.exposeHeaders = builder.exposeHeaders;
        this.anyOrigin = builder.anyOrigin;
        this.allowCookies = builder.allowCookies;
        this.maxAge = builder.maxAge;
        this.validRequestMethods = Collections.unmodifiableSet(builder.validRequestMethods);
        this.validRequestHeaders = Collections.unmodifiableSet(builder.validRequestHeaders);
    }

    public static Origin enableCorsSupport() {
        return new Builder().enableCorsSupport();
    }

    public static CorsConfiguration disableCorsSupport() {
        return new Builder().disableCorsSupport();
    }

    public static CorsConfiguration defaultConfig() {
        return CorsConfig.enableCorsSupport().build();
    }

    @Override
    public boolean isCorsSupportEnabled() {
        return this.corsSupportEnabled;
    }

    @Override
    public boolean exposeHeaders() {
        return this.exposeHeaders != null;
    }

    @Override
    public String getExposeHeaders() {
        return this.exposeHeaders;
    }

    @Override
    public boolean anyOrigin() {
        return this.anyOrigin;
    }

    @Override
    public boolean allowCookies() {
        return this.allowCookies;
    }

    @Override
    public boolean hasMaxAge() {
        return this.maxAge > -1L;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    @Override
    public Set<String> getValidRequestMethods() {
        return this.validRequestMethods;
    }

    @Override
    public Set<String> getValidRequestHeaders() {
        return this.validRequestHeaders;
    }

    public String toString() {
        return "CorsConfiguration[" + "corsSupportEnabled=" + this.corsSupportEnabled + ", exposeHeaders=" + this.exposeHeaders + ", anyOrigin=" + this.anyOrigin + ", allowCookies=" + this.allowCookies + ", maxAge=" + this.maxAge + ", validRequestHeaders=" + this.validRequestHeaders + ", validRequestMethods=" + this.validRequestMethods + "]";
    }

    private static class Builder
    implements SupportedOptions,
    Origin,
    ExposeHeaders,
    Cookies,
    MaxAge,
    ValidRequestHeaders,
    ValidRequestMethods {
        private boolean corsSupportEnabled = true;
        private boolean anyOrigin;
        private boolean allowCookies;
        private long maxAge;
        private String exposeHeaders;
        private Set<String> validRequestMethods = new HashSet<String>();
        private Set<String> validRequestHeaders = new HashSet<String>();

        @Override
        public Origin enableCorsSupport() {
            this.corsSupportEnabled = true;
            return this;
        }

        @Override
        public CorsConfiguration disableCorsSupport() {
            this.corsSupportEnabled = false;
            return this.build();
        }

        @Override
        public Cookies anyOrigin() {
            this.anyOrigin = true;
            return this;
        }

        @Override
        public Cookies echoOrigin() {
            this.anyOrigin = false;
            return this;
        }

        @Override
        public ExposeHeaders enableCookies() {
            this.allowCookies = true;
            return this;
        }

        @Override
        public ExposeHeaders disableCookies() {
            this.allowCookies = false;
            return this;
        }

        @Override
        public MaxAge exposeHeaders(String headers) {
            this.exposeHeaders = headers;
            return this;
        }

        @Override
        public ValidRequestMethods maxAge(long age) {
            this.maxAge = age;
            return this;
        }

        @Override
        public ValidRequestHeaders validRequestMethods(RequestMethod ... requestMethods) {
            this.validRequestMethods.addAll(this.asSet(requestMethods));
            return this;
        }

        @Override
        public ValidRequestHeaders enableAllRequestMethods() {
            this.validRequestMethods(RequestMethod.values());
            return this;
        }

        @Override
        public CorsConfiguration validRequestHeaders(String validHeaders) {
            this.validRequestHeaders.addAll(this.asSet(validHeaders, true));
            return this.build();
        }

        private Set<String> asSet(RequestMethod ... requestMethods) {
            String join = Joiner.on((String)",").join((Object[])requestMethods);
            return this.asSet(join, false);
        }

        private Set<String> asSet(String csvString, boolean toLowerCase) {
            if (csvString == null) {
                return Collections.emptySet();
            }
            LinkedHashSet<String> strings = new LinkedHashSet<String>();
            for (String string : Splitter.on((char)',').trimResults().split((CharSequence)csvString)) {
                strings.add(toLowerCase ? string.toLowerCase() : string);
            }
            return strings;
        }

        @Override
        public CorsConfiguration build() {
            this.validRequestHeaders.add("origin");
            if (this.validRequestMethods.isEmpty()) {
                this.enableAllRequestMethods();
            }
            return new CorsConfig(this);
        }
    }

    public static interface ValidRequestHeaders {
        public CorsConfiguration validRequestHeaders(String var1);

        public CorsConfiguration build();
    }

    public static interface ValidRequestMethods {
        public ValidRequestHeaders validRequestMethods(RequestMethod ... var1);

        public ValidRequestHeaders enableAllRequestMethods();

        public CorsConfiguration build();
    }

    public static interface MaxAge {
        public ValidRequestMethods maxAge(long var1);

        public CorsConfiguration build();
    }

    public static interface ExposeHeaders
    extends MaxAge {
        public MaxAge exposeHeaders(String var1);

        @Override
        public CorsConfiguration build();
    }

    public static interface Cookies {
        public ExposeHeaders enableCookies();

        public ExposeHeaders disableCookies();

        public CorsConfiguration build();
    }

    public static interface Origin {
        public Cookies anyOrigin();

        public Cookies echoOrigin();

        public CorsConfiguration build();
    }

    public static interface SupportedOptions {
        public Origin enableCorsSupport();

        public CorsConfiguration disableCorsSupport();

        public CorsConfiguration build();
    }
}

