/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.controller.log;

import java.util.Collection;
import java.util.Set;
import javax.servlet.ServletException;
import org.jboss.aerogear.controller.router.Consumer;
import org.jboss.aerogear.controller.router.RequestMethod;
import org.jboss.aerogear.controller.router.Responders;
import org.jboss.aerogear.controller.router.parameter.MissingRequestParameterException;
import org.jboss.aerogear.controller.router.parameter.Parameter;
import org.jboss.aerogear.controller.router.rest.pagination.PaginationRequestException;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;

@MessageBundle(projectCode="AG_CONTROLLER")
public interface ExceptionBundle {
    public static final ExceptionBundle MESSAGES = (ExceptionBundle)Messages.getBundle(ExceptionBundle.class);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=1, value="must be run inside a Servlet container")
    public ServletException mustRunInsideAContainer();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="No route found for method: '%s', requested URI: '%s', Accept: '%s'")
    public RuntimeException routeNotFound(RequestMethod var1, String var2, Set<String> var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="oops, multivalued params not supported yet. Parameter name: '%s'")
    public RuntimeException multivaluedParamsUnsupported(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Parameter: '%s' was missing from Request")
    public MissingRequestParameterException missingParameterInRequest(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=11, value="No Responder was found that matched the Accept Header: '%s'. The following Responders are registered: '%s'")
    public RuntimeException noResponderForRequestedMediaType(String var1, Responders var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12, value="No Consumer found for Parameter: '%s'. The registered Consumers were: '%s'. Please add a Consumer for one the media types supported by the route: %s.")
    public RuntimeException noConsumerForMediaType(Parameter<?> var1, Collection<Consumer> var2, Set<String> var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=13, value="Invalid Paging Request: offset '%s', limit '%s'")
    public PaginationRequestException invalidPagingRequest(long var1, long var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="The class '%s', does not have a no-args constructor which is required by CDI.")
    public RuntimeException responderDoesNotHaveNoArgsCtor(Class<?> var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=15, value="No routes were found in the deployment. Please verify that you have implemented RoutingModule, and that the deployment has a beans.xml file in WEB-INF")
    public RuntimeException noRoutesAvailable();
}

